/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote;

import com.sun.jmx.remote.util.EnvHelp;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.BitSet;
import java.util.StringTokenizer;

public class JMXServiceURL
implements Serializable {
    private static final long serialVersionUID = 8173364409860779292L;
    private static final Exception randomException;
    private static final BitSet alphaBitSet;
    private static final BitSet numericBitSet;
    private static final BitSet alphaNumericBitSet;
    private static final BitSet protocolBitSet;
    private static final BitSet hostNameBitSet;
    private final String protocol;
    private final String host;
    private final int port;
    private final String urlPath;
    private transient String toString;

    public JMXServiceURL(String string) throws MalformedURLException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = string.length();
        for (int i = 0; i < n5; ++i) {
            n4 = string.charAt(i);
            if (n4 >= 32 && n4 < 127) continue;
            throw new MalformedURLException("Service URL contains non-ASCII character 0x" + Integer.toHexString(n4));
        }
        n4 = "service:jmx:".length();
        if (!string.regionMatches(true, 0, "service:jmx:", 0, n4)) {
            throw new MalformedURLException("Service URL must start with service:jmx:");
        }
        int[] nArray = new int[1];
        int n6 = n4;
        int n7 = JMXServiceURL.indexOf(string, ':', n6);
        this.protocol = string.substring(n6, n7).toLowerCase();
        if (!string.regionMatches(n7, "://", 0, 3)) {
            throw new MalformedURLException("Missing \"://\" after protocol name");
        }
        int n8 = n7 + 3;
        if (n8 < n5 && string.charAt(n8) == '[') {
            n3 = string.indexOf(93, n8) + 1;
            if (n3 == 0) {
                throw new MalformedURLException("Bad host name: [ without ]");
            }
            this.host = string.substring(n8 + 1, n3 - 1);
            if (!JMXServiceURL.isNumericIPv6Address(this.host)) {
                throw new MalformedURLException("Address inside [...] must be numeric IPv6 address");
            }
        } else {
            n3 = JMXServiceURL.indexOfFirstNotInSet(string, hostNameBitSet, n8);
            this.host = string.substring(n8, n3);
        }
        if (n3 < n5 && string.charAt(n3) == ':') {
            if (this.host.length() == 0) {
                throw new MalformedURLException("Cannot give port number without host name");
            }
            n2 = n3 + 1;
            n = JMXServiceURL.indexOfFirstNotInSet(string, numericBitSet, n2);
            String string2 = string.substring(n2, n);
            try {
                this.port = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MalformedURLException("Bad port number: \"" + string2 + "\": " + numberFormatException);
            }
        } else {
            n = n3;
            this.port = 0;
        }
        n2 = n;
        this.urlPath = n2 < n5 ? string.substring(n2) : "";
        this.validate();
    }

    public JMXServiceURL(String string, String string2, int n) throws MalformedURLException {
        this(string, string2, n, null);
    }

    public JMXServiceURL(String string, String string2, int n, String string3) throws MalformedURLException {
        if (string == null) {
            string = "jmxmp";
        }
        if (string2 == null) {
            try {
                string2 = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                throw new MalformedURLException("Local host name unknown: " + unknownHostException);
            }
        }
        if (string2.startsWith("[")) {
            if (!string2.endsWith("]")) {
                throw new MalformedURLException("Host starts with [ but does not end with ]");
            }
            if (!JMXServiceURL.isNumericIPv6Address(string2 = string2.substring(1, string2.length() - 1))) {
                throw new MalformedURLException("Address inside [...] must be numeric IPv6 address");
            }
            if (string2.startsWith("[")) {
                throw new MalformedURLException("More than one [[...]]");
            }
        }
        this.protocol = string.toLowerCase();
        this.host = string2;
        this.port = n;
        if (string3 == null) {
            string3 = "";
        }
        this.urlPath = string3;
        this.validate();
    }

    private void validate() throws MalformedURLException {
        int n = JMXServiceURL.indexOfFirstNotInSet(this.protocol, protocolBitSet, 0);
        if (n == 0 || n < this.protocol.length() || !alphaBitSet.get(this.protocol.charAt(0))) {
            throw new MalformedURLException("Missing or invalid protocol name: \"" + this.protocol + "\"");
        }
        this.validateHost();
        if (this.port < 0) {
            throw new MalformedURLException("Bad port: " + this.port);
        }
        if (this.urlPath.length() > 0 && !this.urlPath.startsWith("/") && !this.urlPath.startsWith(";")) {
            throw new MalformedURLException("Bad URL path: " + this.urlPath);
        }
    }

    private void validateHost() throws MalformedURLException {
        int n;
        if (this.host.length() == 0) {
            if (this.port != 0) {
                throw new MalformedURLException("Cannot give port number without host name");
            }
            return;
        }
        if (JMXServiceURL.isNumericIPv6Address(this.host)) {
            try {
                InetAddress.getByName(this.host);
            }
            catch (Exception exception) {
                MalformedURLException malformedURLException = new MalformedURLException("Bad IPv6 address: " + this.host);
                EnvHelp.initCause(malformedURLException, exception);
                throw malformedURLException;
            }
        }
        int n2 = this.host.length();
        int n3 = 46;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            n = this.host.charAt(i);
            boolean bl = alphaNumericBitSet.get(n);
            if (n3 == 46) {
                n4 = n;
            }
            if (bl) {
                n3 = 97;
                continue;
            }
            if (n == 45) {
                if (n3 == 46) break;
                n3 = 45;
                continue;
            }
            if (n == 46) {
                if (n3 != 97) break;
                n3 = 46;
                continue;
            }
            n3 = 46;
            break;
        }
        try {
            if (n3 != 97) {
                throw randomException;
            }
            if (!alphaBitSet.get(n4)) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.host, ".", true);
                for (n = 0; n < 4; ++n) {
                    String string = stringTokenizer.nextToken();
                    int n5 = Integer.parseInt(string);
                    if (n5 < 0 || n5 > 255) {
                        throw randomException;
                    }
                    if (n >= 3 || stringTokenizer.nextToken().equals(".")) continue;
                    throw randomException;
                }
                if (stringTokenizer.hasMoreTokens()) {
                    throw randomException;
                }
            }
        }
        catch (Exception exception) {
            throw new MalformedURLException("Bad host: \"" + this.host + "\"");
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getURLPath() {
        return this.urlPath;
    }

    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        StringBuffer stringBuffer = new StringBuffer("service:jmx:");
        stringBuffer.append(this.getProtocol()).append("://");
        String string = this.getHost();
        if (JMXServiceURL.isNumericIPv6Address(string)) {
            stringBuffer.append('[').append(string).append(']');
        } else {
            stringBuffer.append(string);
        }
        int n = this.getPort();
        if (n != 0) {
            stringBuffer.append(':').append(n);
        }
        stringBuffer.append(this.getURLPath());
        this.toString = stringBuffer.toString();
        return this.toString;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JMXServiceURL)) {
            return false;
        }
        JMXServiceURL jMXServiceURL = (JMXServiceURL)object;
        return jMXServiceURL.getProtocol().equalsIgnoreCase(this.getProtocol()) && jMXServiceURL.getHost().equalsIgnoreCase(this.getHost()) && jMXServiceURL.getPort() == this.getPort() && jMXServiceURL.getURLPath().equals(this.getURLPath());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private static boolean isNumericIPv6Address(String string) {
        return string.indexOf(58) >= 0;
    }

    private static int indexOf(String string, char c, int n) {
        int n2 = string.indexOf(c, n);
        if (n2 < 0) {
            return string.length();
        }
        return n2;
    }

    private static int indexOfFirstNotInSet(String string, BitSet bitSet, int n) {
        char c;
        int n2;
        int n3 = string.length();
        for (n2 = n; n2 < n3 && (c = string.charAt(n2)) < '\u0080' && bitSet.get(c); ++n2) {
        }
        return n2;
    }

    private static void addCharsToBitSet(BitSet bitSet, String string) {
        for (int i = 0; i < string.length(); ++i) {
            bitSet.set(string.charAt(i));
        }
    }

    static {
        int n;
        randomException = new Exception();
        alphaBitSet = new BitSet(128);
        numericBitSet = new BitSet(128);
        alphaNumericBitSet = new BitSet(128);
        protocolBitSet = new BitSet(128);
        hostNameBitSet = new BitSet(128);
        for (n = 48; n <= 57; n = (int)((char)(n + 1))) {
            numericBitSet.set(n);
        }
        for (n = 65; n <= 90; n = (int)((char)(n + 1))) {
            alphaBitSet.set(n);
        }
        for (n = 97; n <= 122; n = (int)((char)(n + 1))) {
            alphaBitSet.set(n);
        }
        alphaNumericBitSet.or(alphaBitSet);
        alphaNumericBitSet.or(numericBitSet);
        protocolBitSet.or(alphaNumericBitSet);
        protocolBitSet.set(43);
        protocolBitSet.set(45);
        hostNameBitSet.or(alphaNumericBitSet);
        hostNameBitSet.set(45);
        hostNameBitSet.set(46);
    }
}

