/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.definition.digester;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.tiles.Attribute;
import org.apache.tiles.Definition;
import org.apache.tiles.context.ListAttribute;
import org.apache.tiles.definition.DefinitionsFactoryException;
import org.apache.tiles.definition.DefinitionsReader;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DigesterDefinitionsReader
implements DefinitionsReader {
    public static final String PARSER_VALIDATE_PARAMETER_NAME = "org.apache.tiles.definition.digester.DigesterDefinitionsReader.PARSER_VALIDATE";
    private static final String DEFINITION_TAG = "tiles-definitions/definition";
    private static final String PUT_TAG = "tiles-definitions/definition/put-attribute";
    private static final String LIST_TAG = "put-list-attribute";
    private static final String DEF_LIST_TAG = "tiles-definitions/definition/put-list-attribute";
    private static final String ADD_LIST_ELE_TAG = "*/add-attribute";
    private static final String NESTED_LIST = "*/add-list-attribute";
    private static final String ADD_WILDCARD = "*/item";
    private static final String BEAN_TAG = "*/bean";
    private static final String DEFINITION_HANDLER_CLASS = Definition.class.getName();
    private static final String PUT_ATTRIBUTE_HANDLER_CLASS = Attribute.class.getName();
    private static final String LIST_HANDLER_CLASS = ListAttribute.class.getName();
    protected Digester digester;
    private Map<String, Definition> definitions;
    protected boolean validating = true;
    protected String[] registrations = new String[]{"-//Apache Software Foundation//DTD Tiles Configuration 2.0//EN", "/org/apache/tiles/resources/tiles-config_2_0.dtd"};
    private boolean inited = false;

    public DigesterDefinitionsReader() {
        this.digester = new Digester();
        this.digester.setValidating(this.validating);
        this.digester.setNamespaceAware(true);
        this.digester.setUseContextClassLoader(true);
        this.digester.setErrorHandler((ErrorHandler)new ThrowingErrorHandler());
        for (int i = 0; i < this.registrations.length; i += 2) {
            URL url = this.getClass().getResource(this.registrations[i + 1]);
            if (url == null) continue;
            this.digester.register(this.registrations[i], url.toString());
        }
    }

    @Override
    public Map<String, Definition> read(Object source) throws DefinitionsFactoryException {
        InputStream input;
        if (!this.inited) {
            throw new DefinitionsFactoryException("Definitions reader has not been initialized.");
        }
        this.definitions = new HashMap<String, Definition>();
        if (source == null) {
            return null;
        }
        try {
            input = (InputStream)source;
        }
        catch (ClassCastException e) {
            throw new DefinitionsFactoryException("Invalid source type.  Requires java.io.InputStream.", e);
        }
        try {
            this.digester.push((Object)this);
            this.digester.parse(input);
        }
        catch (SAXException e) {
            throw new DefinitionsFactoryException("XML error reading definitions.", e);
        }
        catch (IOException e) {
            throw new DefinitionsFactoryException("I/O Error reading definitions.", e);
        }
        return this.definitions;
    }

    @Override
    public void init(Map<String, String> params) throws DefinitionsFactoryException {
        String value;
        if (params != null && (value = params.get(PARSER_VALIDATE_PARAMETER_NAME)) != null) {
            this.digester.setValidating(Boolean.valueOf(value).booleanValue());
        }
        this.initDigesterForTilesDefinitionsSyntax(this.digester);
        this.inited = true;
    }

    private void initDigesterForTilesDefinitionsSyntax(Digester digester) {
        digester.addObjectCreate(DEFINITION_TAG, DEFINITION_HANDLER_CLASS);
        digester.addSetProperties(DEFINITION_TAG);
        digester.addSetNext(DEFINITION_TAG, "addDefinition", DEFINITION_HANDLER_CLASS);
        digester.addObjectCreate(PUT_TAG, PUT_ATTRIBUTE_HANDLER_CLASS);
        digester.addRule(PUT_TAG, (Rule)new FillAttributeRule());
        digester.addRule(PUT_TAG, (Rule)new PutAttributeRule());
        digester.addCallMethod(PUT_TAG, "setBody", 0);
        digester.addObjectCreate(DEF_LIST_TAG, LIST_HANDLER_CLASS);
        digester.addSetProperties(DEF_LIST_TAG);
        digester.addRule(DEF_LIST_TAG, (Rule)new PutAttributeRule());
        digester.addObjectCreate(ADD_LIST_ELE_TAG, PUT_ATTRIBUTE_HANDLER_CLASS);
        digester.addRule(ADD_LIST_ELE_TAG, (Rule)new FillAttributeRule());
        digester.addSetNext(ADD_LIST_ELE_TAG, "add", PUT_ATTRIBUTE_HANDLER_CLASS);
        digester.addCallMethod(ADD_LIST_ELE_TAG, "setBody", 0);
        digester.addObjectCreate(NESTED_LIST, LIST_HANDLER_CLASS);
        digester.addSetProperties(NESTED_LIST);
        digester.addSetNext(NESTED_LIST, "add", PUT_ATTRIBUTE_HANDLER_CLASS);
        String menuItemDefaultClass = "org.apache.tiles.beans.SimpleMenuItem";
        digester.addObjectCreate(ADD_WILDCARD, menuItemDefaultClass, "classtype");
        digester.addSetNext(ADD_WILDCARD, "add", "java.lang.Object");
        digester.addSetProperties(ADD_WILDCARD);
        String beanDefaultClass = "org.apache.tiles.beans.SimpleMenuItem";
        digester.addObjectCreate(BEAN_TAG, beanDefaultClass, "classtype");
        digester.addSetProperties(BEAN_TAG);
        digester.addSetNext(BEAN_TAG, "add", "java.lang.Object");
        digester.addSetProperty("*/bean/set-property", "property", "value");
    }

    public void addDefinition(Definition definition) {
        this.definitions.put(definition.getName(), definition);
    }

    private static class ThrowingErrorHandler
    implements ErrorHandler {
        private ThrowingErrorHandler() {
        }

        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }

        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }

    private static class PutAttributeRule
    extends Rule {
        private PutAttributeRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) throws Exception {
            Attribute attribute = (Attribute)this.digester.peek(0);
            Definition definition = (Definition)this.digester.peek(1);
            definition.putAttribute(attributes.getValue("name"), attribute);
        }
    }

    private static class FillAttributeRule
    extends Rule {
        private FillAttributeRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) throws Exception {
            Attribute attribute = (Attribute)this.digester.peek();
            attribute.setValue((Object)attributes.getValue("value"));
            attribute.setRole(attributes.getValue("role"));
            attribute.setType(Attribute.AttributeType.getType((String)attributes.getValue("type")));
        }
    }
}

