/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.proxy;

import com.jamonapi.BasicTimingMonitor;
import com.jamonapi.MonitorComposite;
import com.jamonapi.MonitorFactory;
import com.jamonapi.proxy.MonProxy;
import com.jamonapi.proxy.MonProxyFactory;
import com.jamonapi.proxy.Params;
import com.jamonapi.proxy.SQLDeArger;
import com.jamonapi.utils.Misc;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

class JDBCMonProxy
extends MonProxy {
    private static Map statementsMap = Collections.synchronizedMap(new WeakHashMap());
    private static Long DEFAULT_SQL_TIME = new Long(-99L);
    private static int ARGS_SQL_STATEMENT = 0;
    private static int SQL_EXECUTION_TIME_IND = 2;
    private static int SQL_EXCEPTION_IND = 5;

    JDBCMonProxy(Object monitoredObj, Params params) {
        super(monitoredObj, params);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object object;
        block27: {
            long executionTime;
            Object returnValue;
            boolean executingQuery;
            boolean isSQLDetailEnabled;
            boolean isSQLSummaryEnabled;
            SQLDeArgMon sqlMon;
            Object[] row;
            BasicTimingMonitor mon;
            block25: {
                Object object2;
                block26: {
                    block23: {
                        PreparedStatement executionTime22;
                        block24: {
                            block21: {
                                Object statementReuseCounter2;
                                block22: {
                                    mon = null;
                                    row = null;
                                    sqlMon = null;
                                    isSQLSummaryEnabled = this.params.isSQLSummaryEnabled && this.params.isEnabled;
                                    isSQLDetailEnabled = this.params.isSQLDetailEnabled && this.params.isEnabled;
                                    executingQuery = this.isExecuteQueryMethod(method.getName());
                                    if (executingQuery && (isSQLSummaryEnabled || isSQLDetailEnabled)) {
                                        String actualSQL = null;
                                        mon = new BasicTimingMonitor();
                                        mon.start();
                                        int statementReuseCounter2 = 0;
                                        if (this.isStatementObject(args)) {
                                            actualSQL = this.getSQL(args[ARGS_SQL_STATEMENT]);
                                            sqlMon = new SQLDeArgMon("Statement", actualSQL, this.params.matchStrings);
                                        } else {
                                            sqlMon = (SQLDeArgMon)statementsMap.get(this.getMonitoredObject());
                                            statementReuseCounter2 = sqlMon.incrementCounter();
                                            if (isSQLSummaryEnabled) {
                                                MonitorFactory.add("MonProxy-SQL-PreparedStatement Reuse", "count", 2 * statementReuseCounter2);
                                            }
                                            actualSQL = this.getSQL(sqlMon.getSQL());
                                        }
                                        if (isSQLSummaryEnabled) {
                                            sqlMon.start();
                                        }
                                        if (isSQLDetailEnabled) {
                                            row = new Object[]{new Long(++this.params.sqlID), new Date(), DEFAULT_SQL_TIME, new Integer(statementReuseCounter2), actualSQL, "", method.toString()};
                                            this.params.sqlBuffer.addRow(row);
                                        }
                                    }
                                    returnValue = super.invoke(proxy, method, args);
                                    if (this.params.isEnabled && !(returnValue instanceof MonProxy)) break block21;
                                    statementReuseCounter2 = returnValue;
                                    if (mon == null || !executingQuery) break block22;
                                    long executionTime22 = mon.stop();
                                    if (isSQLDetailEnabled && row != null) {
                                        row[JDBCMonProxy.SQL_EXECUTION_TIME_IND] = new Long(executionTime22);
                                    }
                                    if (!isSQLSummaryEnabled) break block22;
                                    sqlMon.add(executionTime22).stop();
                                }
                                return statementReuseCounter2;
                            }
                            if (!isSQLSummaryEnabled && !isSQLDetailEnabled || !this.returnsPreparedStatement(method.getName()) || !this.isPreparedStatement(returnValue)) break block23;
                            String actualSQL = this.getSQL(args[ARGS_SQL_STATEMENT]);
                            statementsMap.put(returnValue, new SQLDeArgMon("PreparedStatement", actualSQL, this.params.matchStrings));
                            executionTime22 = MonProxyFactory.monitor((PreparedStatement)returnValue);
                            if (mon == null || !executingQuery) break block24;
                            long executionTime3 = mon.stop();
                            if (isSQLDetailEnabled && row != null) {
                                row[JDBCMonProxy.SQL_EXECUTION_TIME_IND] = new Long(executionTime3);
                            }
                            if (!isSQLSummaryEnabled) break block24;
                            sqlMon.add(executionTime3).stop();
                        }
                        return executionTime22;
                    }
                    if (!isSQLSummaryEnabled && !isSQLDetailEnabled || !this.monitorResultSet(returnValue) && !this.monitorOtherJDBC(returnValue)) break block25;
                    object2 = this.monitorJDBC(returnValue);
                    if (mon == null || !executingQuery) break block26;
                    long executionTime4 = mon.stop();
                    if (isSQLDetailEnabled && row != null) {
                        row[JDBCMonProxy.SQL_EXECUTION_TIME_IND] = new Long(executionTime4);
                    }
                    if (!isSQLSummaryEnabled) break block26;
                    sqlMon.add(executionTime4).stop();
                }
                return object2;
            }
            try {
                object = returnValue;
                if (mon == null || !executingQuery) break block27;
                executionTime = mon.stop();
                if (isSQLDetailEnabled && row != null) {
                    row[JDBCMonProxy.SQL_EXECUTION_TIME_IND] = new Long(executionTime);
                }
                if (!isSQLSummaryEnabled) break block27;
            }
            catch (Throwable e) {
                try {
                    if (executingQuery && isSQLDetailEnabled && row != null) {
                        row[JDBCMonProxy.SQL_EXCEPTION_IND] = Misc.getExceptionTrace(e);
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    if (mon != null && executingQuery) {
                        long executionTime5 = mon.stop();
                        if (isSQLDetailEnabled && row != null) {
                            row[JDBCMonProxy.SQL_EXECUTION_TIME_IND] = new Long(executionTime5);
                        }
                        if (isSQLSummaryEnabled) {
                            sqlMon.add(executionTime5).stop();
                        }
                    }
                    throw throwable;
                }
            }
            sqlMon.add(executionTime).stop();
        }
        return object;
    }

    private boolean isExecuteQueryMethod(String methodName) {
        return "executeQuery".equals(methodName) || "executeUpdate".equals(methodName) || "execute".equals(methodName);
    }

    private boolean returnsPreparedStatement(String methodName) {
        return "prepareStatement".equals(methodName) || "prepareCall".equals(methodName);
    }

    private boolean isStatementObject(Object[] args) {
        return args != null && args.length >= 1;
    }

    private boolean monitorOtherJDBC(Object value) {
        return value instanceof Statement || value instanceof Connection;
    }

    private boolean monitorResultSet(Object value) {
        return value instanceof ResultSet && this.params.isResultSetEnabled && this.params.isInterfaceEnabled;
    }

    private Object monitorJDBC(Object returnValue) {
        if (returnValue instanceof ResultSet) {
            return MonProxyFactory.monitor((ResultSet)returnValue);
        }
        if (returnValue instanceof Statement) {
            return MonProxyFactory.monitor((Statement)returnValue);
        }
        if (returnValue instanceof Connection) {
            return MonProxyFactory.monitor((Connection)returnValue);
        }
        return returnValue;
    }

    private boolean isPreparedStatement(Object value) {
        return value instanceof PreparedStatement;
    }

    private String getSQL(Object sql) {
        return sql == null ? "null sql" : sql.toString();
    }

    public static void main(String[] args) {
        SQLDeArgMon sqlMon = new SQLDeArgMon("Statement", "select * from table where name='steve'", null);
        System.out.println(sqlMon);
    }

    private static class SQLDeArgMon {
        private int accessCounter = 0;
        private String sql;
        private int monRows;
        private static final int LABEL_IND = 0;
        private MonitorComposite monitors = null;
        private String[][] data = null;

        SQLDeArgMon(String statementType, String sql, List matchStrings) {
            SQLDeArger sqld = new SQLDeArger(sql, matchStrings);
            this.sql = sqld.getParsedSQL();
            this.data = sqld.getAll();
            this.monRows = this.data.length;
            for (int i = 0; i < this.monRows; ++i) {
                StringBuffer label = new StringBuffer("MonProxy-SQL-");
                this.data[i][0] = i == 0 ? label.append("Type: ").append(this.data[i][0]).toString() : (i == 1 ? label.append("Type: ").append(this.data[i][0]).toString() : (i == 2 ? label.append(statementType).append(": ").append(this.data[i][0]).toString() : label.append("Match: ").append(this.data[i][0]).toString()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SQLDeArgMon start() {
            SQLDeArgMon sQLDeArgMon = this;
            synchronized (sQLDeArgMon) {
                if (this.monitors == null) {
                    this.monitors = MonitorComposite.getMonitors(this.data);
                    this.data = null;
                }
            }
            this.monitors.start();
            return this;
        }

        private SQLDeArgMon stop() {
            this.monitors.stop();
            return this;
        }

        private SQLDeArgMon add(double time) {
            this.monitors.add(time);
            return this;
        }

        private synchronized int incrementCounter() {
            return this.accessCounter++;
        }

        private String getSQL() {
            return this.sql;
        }

        public String toString() {
            return "accessCounter=" + this.accessCounter + ", sql=" + this.sql;
        }
    }
}

