/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.trace.Trace;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

final class MBeanServerDelegateImpl
extends MBeanServerDelegate
implements DynamicMBean,
MBeanRegistration {
    private static final String dbgTag = "MBeanServerDelegateImpl";
    private static final String[] attributeNames = new String[]{"MBeanServerId", "SpecificationName", "SpecificationVersion", "SpecificationVendor", "ImplementationName", "ImplementationVersion", "ImplementationVendor"};
    private static final MBeanAttributeInfo[] attributeInfos = new MBeanAttributeInfo[]{new MBeanAttributeInfo("MBeanServerId", "java.lang.String", "The MBean server agent identification", true, false, false), new MBeanAttributeInfo("SpecificationName", "java.lang.String", "The full name of the JMX specification implemented by this product.", true, false, false), new MBeanAttributeInfo("SpecificationVersion", "java.lang.String", "The version of the JMX specification implemented by this product.", true, false, false), new MBeanAttributeInfo("SpecificationVendor", "java.lang.String", "The vendor of the JMX specification implemented by this product.", true, false, false), new MBeanAttributeInfo("ImplementationName", "java.lang.String", "The JMX implementation name (the name of this product)", true, false, false), new MBeanAttributeInfo("ImplementationVersion", "java.lang.String", "The JMX implementation version (the version of this product).", true, false, false), new MBeanAttributeInfo("ImplementationVendor", "java.lang.String", "the JMX implementation vendor (the vendor of this product).", true, false, false)};
    private final MBeanInfo delegateInfo = new MBeanInfo("javax.management.MBeanServerDelegate", "Represents  the MBean server from the management point of view.", attributeInfos, null, null, this.getNotificationInfo());

    public final ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        if (objectName == null) {
            return new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        return objectName;
    }

    public final void postRegister(Boolean bl) {
    }

    public final void preDeregister() throws Exception {
        throw new IllegalArgumentException("The MBeanServerDelegate MBean cannot be unregistered");
    }

    public final void postDeregister() {
    }

    public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            if (string == null) {
                throw new AttributeNotFoundException("null");
            }
            if (string.equals("MBeanServerId")) {
                return this.getMBeanServerId();
            }
            if (string.equals("SpecificationName")) {
                return this.getSpecificationName();
            }
            if (string.equals("SpecificationVersion")) {
                return this.getSpecificationVersion();
            }
            if (string.equals("SpecificationVendor")) {
                return this.getSpecificationVendor();
            }
            if (string.equals("ImplementationName")) {
                return this.getImplementationName();
            }
            if (string.equals("ImplementationVersion")) {
                return this.getImplementationVersion();
            }
            if (string.equals("ImplementationVendor")) {
                return this.getImplementationVendor();
            }
            throw new AttributeNotFoundException("null");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw attributeNotFoundException;
        }
        catch (JMRuntimeException jMRuntimeException) {
            throw jMRuntimeException;
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Exception exception) {
            throw new MBeanException(exception, "Failed to get " + string);
        }
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        String string;
        String string2 = string = attribute == null ? null : attribute.getName();
        if (string == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Attribute name cannot be null");
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occured trying to invoke the setter on the MBean");
        }
        Object object = this.getAttribute(string);
        throw new AttributeNotFoundException(string + " not accessible");
    }

    public AttributeList getAttributes(String[] stringArray) {
        String[] stringArray2 = stringArray == null ? attributeNames : stringArray;
        int n = stringArray2.length;
        AttributeList attributeList = new AttributeList(n);
        for (int i = 0; i < n; ++i) {
            try {
                Attribute attribute = new Attribute(stringArray2[i], this.getAttribute(stringArray2[i]));
                attributeList.add(attribute);
                continue;
            }
            catch (Exception exception) {
                MBeanServerDelegateImpl.debug("getAttributes", "Attribute " + stringArray2[i] + " not found.");
            }
        }
        return attributeList;
    }

    public AttributeList setAttributes(AttributeList attributeList) {
        return new AttributeList(0);
    }

    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        if (string == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Operation name  cannot be null");
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occured trying to invoke the operation on the MBean");
        }
        throw new ReflectionException(new NoSuchMethodException(string), "The operation with name " + string + " could not be found");
    }

    public MBeanInfo getMBeanInfo() {
        return this.delegateInfo;
    }

    private static final boolean isTraceOn() {
        return Trace.isSelected(1, 1);
    }

    private static final void trace(String string, String string2, String string3) {
        Trace.send(1, 1, string, string2, string3);
    }

    private static final void trace(String string, String string2) {
        MBeanServerDelegateImpl.trace(dbgTag, string, string2);
    }

    private static final boolean isDebugOn() {
        return Trace.isSelected(2, 1);
    }

    private static final void debug(String string, String string2, String string3) {
        Trace.send(2, 1, string, string2, string3);
    }

    private static final void debug(String string, String string2) {
        MBeanServerDelegateImpl.debug(dbgTag, string, string2);
    }
}

