/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import org.jruby.Ruby;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.builtin.IRubyObject;

public class UndefinedAccessor
implements IAccessor {
    private final Ruby runtime;
    private final GlobalVariable globalVariable;
    private final String notInitializedWarning;
    static final /* synthetic */ boolean $assertionsDisabled;

    public UndefinedAccessor(Ruby runtime, GlobalVariable globalVariable, String name) {
        if (!$assertionsDisabled && runtime == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && globalVariable == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        this.runtime = runtime;
        this.globalVariable = globalVariable;
        this.notInitializedWarning = "global variable `" + name + "' not initialized";
    }

    public IRubyObject getValue() {
        this.runtime.getWarnings().warning(this.notInitializedWarning);
        return this.runtime.getNil();
    }

    public IRubyObject setValue(IRubyObject newValue) {
        if (!$assertionsDisabled && newValue == null) {
            throw new AssertionError();
        }
        this.globalVariable.setAccessor(new ValueAccessor(newValue));
        return newValue;
    }

    static {
        $assertionsDisabled = !UndefinedAccessor.class.desiredAssertionStatus();
    }
}

