/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.queries.InterfaceContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.converters.Converter;

public class DirectMapContainerPolicy
extends InterfaceContainerPolicy {
    protected DatabaseField keyField;
    protected DatabaseField valueField;
    protected Converter keyConverter;
    protected Converter valueConverter;

    public DirectMapContainerPolicy() {
    }

    public DirectMapContainerPolicy(Class containerClass) {
        super(containerClass);
    }

    public boolean addInto(Object key, Object value, Object container, AbstractSession session) {
        try {
            ((Map)container).put(key, value);
        }
        catch (ClassCastException ex1) {
            throw QueryException.cannotAddElement(key, container, ex1);
        }
        return true;
    }

    public boolean addInto(Object element, Object container, AbstractSession session) {
        throw ValidationException.operationNotSupported("addInto(Object element, Object container, Session session)");
    }

    public Object buildContainerFromVector(Vector vector, AbstractSession session) {
        Map container = (Map)this.containerInstance(vector.size());
        Enumeration e = vector.elements();
        while (e.hasMoreElements()) {
            AbstractRecord row = (AbstractRecord)e.nextElement();
            Object key = row.get(this.keyField);
            Object value = row.get(this.valueField);
            if (this.getKeyConverter() != null) {
                key = this.getKeyConverter().convertDataValueToObjectValue(key, session);
            }
            if (this.getValueConverter() != null) {
                value = this.getValueConverter().convertDataValueToObjectValue(value, session);
            }
            if (key == null) continue;
            container.put(key, value);
        }
        return container;
    }

    public void clear(Object container) {
        try {
            ((Map)container).clear();
        }
        catch (UnsupportedOperationException ex) {
            throw QueryException.methodNotValid(container, "clear()");
        }
    }

    public boolean compareContainers(Object firstObjectMap, Object secondObjectMap) {
        if (this.sizeFor(firstObjectMap) != this.sizeFor(secondObjectMap)) {
            return false;
        }
        Object firstIterator = this.iteratorFor(firstObjectMap);
        while (this.hasNext(firstIterator)) {
            Object key = this.next(firstIterator);
            if (((Map)firstObjectMap).get(key).equals(((Map)secondObjectMap).get(key))) continue;
            return false;
        }
        return true;
    }

    public boolean compareKeys(Object sourceValue, AbstractSession session) {
        Object backUpVersion = null;
        backUpVersion = ((UnitOfWorkImpl)session).isClassReadOnly(sourceValue.getClass()) ? ((UnitOfWorkImpl)session).getOriginalVersionOfObject(sourceValue) : ((UnitOfWorkImpl)session).getBackupClone(sourceValue);
        return this.keyFrom(backUpVersion, session).equals(this.keyFrom(sourceValue, session));
    }

    protected boolean contains(Object element, Object container) {
        return ((Map)container).containsValue(element);
    }

    public Class getInterfaceType() {
        return ClassConstants.Map_Class;
    }

    public boolean isDirectMapPolicy() {
        return true;
    }

    public Object iteratorFor(Object container) {
        if (((Map)container).keySet() == null) {
            return null;
        }
        return ((Map)container).keySet().iterator();
    }

    public Object iteratorForValue(Object container) {
        if (((Map)container).values() == null) {
            return null;
        }
        return ((Map)container).values().iterator();
    }

    public boolean removeFrom(Object key, Object element, Object container, AbstractSession session) {
        try {
            Object returnValue = null;
            returnValue = key != null ? ((Map)container).remove(key) : ((Map)container).remove(this.keyFrom(element, session));
            return returnValue != null;
        }
        catch (UnsupportedOperationException ex) {
            throw QueryException.methodNotValid(container, "remove(Object element)");
        }
    }

    public boolean removeFromWithIdentity(Object element, Object container, AbstractSession session) {
        boolean found = false;
        Vector knownKeys = new Vector(1);
        try {
            for (Object key : ((Map)container).keySet()) {
                if (((Map)container).get(key) != element) continue;
                knownKeys.addElement(key);
                found = true;
            }
            if (found) {
                for (int index = 0; index < knownKeys.size(); ++index) {
                    ((Map)container).remove(knownKeys.elementAt(index));
                }
            }
            return found;
        }
        catch (UnsupportedOperationException ex) {
            throw QueryException.methodNotValid(container, "remove(Object element)");
        }
    }

    public void setKeyField(DatabaseField field) {
        this.keyField = field;
    }

    public void setValueField(DatabaseField field) {
        this.valueField = field;
    }

    public int sizeFor(Object container) {
        return ((Map)container).size();
    }

    public void validateElementAndRehashIfRequired(Object sourceValue, Object targetMap, AbstractSession session, Object targetVersionOfSource) {
        Object backupValue;
        if (session.isUnitOfWork() && !this.keyFrom(backupValue = ((UnitOfWorkImpl)session).getBackupClone(sourceValue), session).equals(this.keyFrom(sourceValue, session))) {
            this.removeFrom(backupValue, targetMap, session);
            this.addInto(targetVersionOfSource, targetMap, session);
        }
    }

    public boolean isValidContainer(Object container) {
        return container instanceof Map;
    }

    public Object valueFromKey(Object key, Object container) {
        return ((Map)container).get(key);
    }

    public Converter getKeyConverter() {
        return this.keyConverter;
    }

    public void setKeyConverter(Converter keyConverter) {
        this.keyConverter = keyConverter;
    }

    public void setValueConverter(Converter valueConverter) {
        this.valueConverter = valueConverter;
    }

    public Converter getValueConverter() {
        return this.valueConverter;
    }
}

