<?php
/**
 * Copyright 2007 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
# Generated by the protocol buffer compiler. DO NOT EDIT!
# source: google/appengine/datastore/entity_v4.proto

namespace dummy {
  require_once 'google/appengine/runtime/proto/ProtocolMessage.php';
}
namespace google\appengine\datastore\v4\PartitionId {
  class Constants {
    const MAX_DIMENSION_TAG = 100;
  }
}
namespace google\appengine\datastore\v4 {
  class PartitionId extends \google\net\ProtocolMessage {
    public function getDatasetId() {
      if (!isset($this->dataset_id)) {
        return '';
      }
      return $this->dataset_id;
    }
    public function setDatasetId($val) {
      $this->dataset_id = $val;
      return $this;
    }
    public function clearDatasetId() {
      unset($this->dataset_id);
      return $this;
    }
    public function hasDatasetId() {
      return isset($this->dataset_id);
    }
    public function getNamespace() {
      if (!isset($this->namespace)) {
        return '';
      }
      return $this->namespace;
    }
    public function setNamespace($val) {
      $this->namespace = $val;
      return $this;
    }
    public function clearNamespace() {
      unset($this->namespace);
      return $this;
    }
    public function hasNamespace() {
      return isset($this->namespace);
    }
    public function clear() {
      $this->clearDatasetId();
      $this->clearNamespace();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->dataset_id)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->dataset_id));
      }
      if (isset($this->namespace)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->namespace));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->dataset_id)) {
        $out->putVarInt32(26);
        $out->putPrefixedString($this->dataset_id);
      }
      if (isset($this->namespace)) {
        $out->putVarInt32(34);
        $out->putPrefixedString($this->namespace);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 26:
            $length = $d->getVarInt32();
            $this->setDatasetId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 34:
            $length = $d->getVarInt32();
            $this->setNamespace(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasDatasetId()) {
        $this->setDatasetId($x->getDatasetId());
      }
      if ($x->hasNamespace()) {
        $this->setNamespace($x->getNamespace());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->dataset_id) !== isset($x->dataset_id)) return false;
      if (isset($this->dataset_id) && $this->dataset_id !== $x->dataset_id) return false;
      if (isset($this->namespace) !== isset($x->namespace)) return false;
      if (isset($this->namespace) && $this->namespace !== $x->namespace) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->dataset_id)) {
        $res .= $prefix . "dataset_id: " . $this->debugFormatString($this->dataset_id) . "\n";
      }
      if (isset($this->namespace)) {
        $res .= $prefix . "namespace: " . $this->debugFormatString($this->namespace) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4\Key {
  class PathElement extends \google\net\ProtocolMessage {
    public function getKind() {
      if (!isset($this->kind)) {
        return '';
      }
      return $this->kind;
    }
    public function setKind($val) {
      $this->kind = $val;
      return $this;
    }
    public function clearKind() {
      unset($this->kind);
      return $this;
    }
    public function hasKind() {
      return isset($this->kind);
    }
    public function getId() {
      if (!isset($this->id)) {
        return "0";
      }
      return $this->id;
    }
    public function setId($val) {
      if (is_double($val)) {
        $this->id = sprintf('%0.0F', $val);
      } else {
        $this->id = $val;
      }
      return $this;
    }
    public function clearId() {
      unset($this->id);
      return $this;
    }
    public function hasId() {
      return isset($this->id);
    }
    public function getName() {
      if (!isset($this->name)) {
        return '';
      }
      return $this->name;
    }
    public function setName($val) {
      $this->name = $val;
      return $this;
    }
    public function clearName() {
      unset($this->name);
      return $this;
    }
    public function hasName() {
      return isset($this->name);
    }
    public function clear() {
      $this->clearKind();
      $this->clearId();
      $this->clearName();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->kind)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->kind));
      }
      if (isset($this->id)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->id);
      }
      if (isset($this->name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->name));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->kind)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->kind);
      }
      if (isset($this->id)) {
        $out->putVarInt32(16);
        $out->putVarInt64($this->id);
      }
      if (isset($this->name)) {
        $out->putVarInt32(26);
        $out->putPrefixedString($this->name);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setKind(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 16:
            $this->setId($d->getVarInt64());
            break;
          case 26:
            $length = $d->getVarInt32();
            $this->setName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->kind)) return 'kind';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasKind()) {
        $this->setKind($x->getKind());
      }
      if ($x->hasId()) {
        $this->setId($x->getId());
      }
      if ($x->hasName()) {
        $this->setName($x->getName());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->kind) !== isset($x->kind)) return false;
      if (isset($this->kind) && $this->kind !== $x->kind) return false;
      if (isset($this->id) !== isset($x->id)) return false;
      if (isset($this->id) && !$this->integerEquals($this->id, $x->id)) return false;
      if (isset($this->name) !== isset($x->name)) return false;
      if (isset($this->name) && $this->name !== $x->name) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->kind)) {
        $res .= $prefix . "kind: " . $this->debugFormatString($this->kind) . "\n";
      }
      if (isset($this->id)) {
        $res .= $prefix . "id: " . $this->debugFormatInt64($this->id) . "\n";
      }
      if (isset($this->name)) {
        $res .= $prefix . "name: " . $this->debugFormatString($this->name) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4 {
  class Key extends \google\net\ProtocolMessage {
    private $path_element = array();
    public function getPartitionId() {
      if (!isset($this->partition_id)) {
        return new \google\appengine\datastore\v4\PartitionId();
      }
      return $this->partition_id;
    }
    public function mutablePartitionId() {
      if (!isset($this->partition_id)) {
        $res = new \google\appengine\datastore\v4\PartitionId();
        $this->partition_id = $res;
        return $res;
      }
      return $this->partition_id;
    }
    public function clearPartitionId() {
      if (isset($this->partition_id)) {
        unset($this->partition_id);
      }
    }
    public function hasPartitionId() {
      return isset($this->partition_id);
    }
    public function getPathElementSize() {
      return sizeof($this->path_element);
    }
    public function getPathElementList() {
      return $this->path_element;
    }
    public function mutablePathElement($idx) {
      if (!isset($this->path_element[$idx])) {
        $val = new \google\appengine\datastore\v4\Key\PathElement();
        $this->path_element[$idx] = $val;
        return $val;
      }
      return $this->path_element[$idx];
    }
    public function getPathElement($idx) {
      if (isset($this->path_element[$idx])) {
        return $this->path_element[$idx];
      }
      if ($idx >= end(array_keys($this->path_element))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\datastore\v4\Key\PathElement();
    }
    public function addPathElement() {
      $val = new \google\appengine\datastore\v4\Key\PathElement();
      $this->path_element[] = $val;
      return $val;
    }
    public function clearPathElement() {
      $this->path_element = array();
    }
    public function clear() {
      $this->clearPartitionId();
      $this->clearPathElement();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->partition_id)) {
        $res += 1;
        $res += $this->lengthString($this->partition_id->byteSizePartial());
      }
      $this->checkProtoArray($this->path_element);
      $res += 1 * sizeof($this->path_element);
      foreach ($this->path_element as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->partition_id)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->partition_id->byteSizePartial());
        $this->partition_id->outputPartial($out);
      }
      $this->checkProtoArray($this->path_element);
      foreach ($this->path_element as $value) {
        $out->putVarInt32(18);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutablePartitionId()->tryMerge($tmp);
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addPathElement()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (isset($this->partition_id) && (!$this->partition_id->isInitialized())) return 'partition_id';
      foreach ($this->path_element as $value) {
        if (!$value->isInitialized()) return 'path_element';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasPartitionId()) {
        $this->mutablePartitionId()->mergeFrom($x->getPartitionId());
      }
      foreach ($x->getPathElementList() as $v) {
        $this->addPathElement()->copyFrom($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->partition_id) !== isset($x->partition_id)) return false;
      if (isset($this->partition_id) && !$this->partition_id->equals($x->partition_id)) return false;
      if (sizeof($this->path_element) !== sizeof($x->path_element)) return false;
      foreach (array_map(null, $this->path_element, $x->path_element) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->partition_id)) {
        $res .= $prefix . "partition_id <\n" . $this->partition_id->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->path_element as $value) {
        $res .= $prefix . "path_element <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4 {
  class GeoPoint extends \google\net\ProtocolMessage {
    public function getLatitude() {
      if (!isset($this->latitude)) {
        return 0.0;
      }
      return $this->latitude;
    }
    public function setLatitude($val) {
      $this->latitude = $val;
      return $this;
    }
    public function clearLatitude() {
      unset($this->latitude);
      return $this;
    }
    public function hasLatitude() {
      return isset($this->latitude);
    }
    public function getLongitude() {
      if (!isset($this->longitude)) {
        return 0.0;
      }
      return $this->longitude;
    }
    public function setLongitude($val) {
      $this->longitude = $val;
      return $this;
    }
    public function clearLongitude() {
      unset($this->longitude);
      return $this;
    }
    public function hasLongitude() {
      return isset($this->longitude);
    }
    public function clear() {
      $this->clearLatitude();
      $this->clearLongitude();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->latitude)) {
        $res += 9;
      }
      if (isset($this->longitude)) {
        $res += 9;
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->latitude)) {
        $out->putVarInt32(9);
        $out->putDouble($this->latitude);
      }
      if (isset($this->longitude)) {
        $out->putVarInt32(17);
        $out->putDouble($this->longitude);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 9:
            $this->setLatitude($d->getDouble());
            break;
          case 17:
            $this->setLongitude($d->getDouble());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->latitude)) return 'latitude';
      if (!isset($this->longitude)) return 'longitude';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasLatitude()) {
        $this->setLatitude($x->getLatitude());
      }
      if ($x->hasLongitude()) {
        $this->setLongitude($x->getLongitude());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->latitude) !== isset($x->latitude)) return false;
      if (isset($this->latitude) && $this->latitude !== $x->latitude) return false;
      if (isset($this->longitude) !== isset($x->longitude)) return false;
      if (isset($this->longitude) && $this->longitude !== $x->longitude) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->latitude)) {
        $res .= $prefix . "latitude: " . $this->debugFormatDouble($this->latitude) . "\n";
      }
      if (isset($this->longitude)) {
        $res .= $prefix . "longitude: " . $this->debugFormatDouble($this->longitude) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4 {
  class Value extends \google\net\ProtocolMessage {
    private $list_value = array();
    public function getBooleanValue() {
      if (!isset($this->boolean_value)) {
        return false;
      }
      return $this->boolean_value;
    }
    public function setBooleanValue($val) {
      $this->boolean_value = $val;
      return $this;
    }
    public function clearBooleanValue() {
      unset($this->boolean_value);
      return $this;
    }
    public function hasBooleanValue() {
      return isset($this->boolean_value);
    }
    public function getIntegerValue() {
      if (!isset($this->integer_value)) {
        return "0";
      }
      return $this->integer_value;
    }
    public function setIntegerValue($val) {
      if (is_double($val)) {
        $this->integer_value = sprintf('%0.0F', $val);
      } else {
        $this->integer_value = $val;
      }
      return $this;
    }
    public function clearIntegerValue() {
      unset($this->integer_value);
      return $this;
    }
    public function hasIntegerValue() {
      return isset($this->integer_value);
    }
    public function getDoubleValue() {
      if (!isset($this->double_value)) {
        return 0.0;
      }
      return $this->double_value;
    }
    public function setDoubleValue($val) {
      $this->double_value = $val;
      return $this;
    }
    public function clearDoubleValue() {
      unset($this->double_value);
      return $this;
    }
    public function hasDoubleValue() {
      return isset($this->double_value);
    }
    public function getTimestampMicrosecondsValue() {
      if (!isset($this->timestamp_microseconds_value)) {
        return "0";
      }
      return $this->timestamp_microseconds_value;
    }
    public function setTimestampMicrosecondsValue($val) {
      if (is_double($val)) {
        $this->timestamp_microseconds_value = sprintf('%0.0F', $val);
      } else {
        $this->timestamp_microseconds_value = $val;
      }
      return $this;
    }
    public function clearTimestampMicrosecondsValue() {
      unset($this->timestamp_microseconds_value);
      return $this;
    }
    public function hasTimestampMicrosecondsValue() {
      return isset($this->timestamp_microseconds_value);
    }
    public function getKeyValue() {
      if (!isset($this->key_value)) {
        return new \google\appengine\datastore\v4\Key();
      }
      return $this->key_value;
    }
    public function mutableKeyValue() {
      if (!isset($this->key_value)) {
        $res = new \google\appengine\datastore\v4\Key();
        $this->key_value = $res;
        return $res;
      }
      return $this->key_value;
    }
    public function clearKeyValue() {
      if (isset($this->key_value)) {
        unset($this->key_value);
      }
    }
    public function hasKeyValue() {
      return isset($this->key_value);
    }
    public function getEntityValue() {
      if (!isset($this->entity_value)) {
        return new \google\appengine\datastore\v4\Entity();
      }
      return $this->entity_value;
    }
    public function mutableEntityValue() {
      if (!isset($this->entity_value)) {
        $res = new \google\appengine\datastore\v4\Entity();
        $this->entity_value = $res;
        return $res;
      }
      return $this->entity_value;
    }
    public function clearEntityValue() {
      if (isset($this->entity_value)) {
        unset($this->entity_value);
      }
    }
    public function hasEntityValue() {
      return isset($this->entity_value);
    }
    public function getListValueSize() {
      return sizeof($this->list_value);
    }
    public function getListValueList() {
      return $this->list_value;
    }
    public function mutableListValue($idx) {
      if (!isset($this->list_value[$idx])) {
        $val = new \google\appengine\datastore\v4\Value();
        $this->list_value[$idx] = $val;
        return $val;
      }
      return $this->list_value[$idx];
    }
    public function getListValue($idx) {
      if (isset($this->list_value[$idx])) {
        return $this->list_value[$idx];
      }
      if ($idx >= end(array_keys($this->list_value))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\datastore\v4\Value();
    }
    public function addListValue() {
      $val = new \google\appengine\datastore\v4\Value();
      $this->list_value[] = $val;
      return $val;
    }
    public function clearListValue() {
      $this->list_value = array();
    }
    public function getGeoPointValue() {
      if (!isset($this->geo_point_value)) {
        return new \google\appengine\datastore\v4\GeoPoint();
      }
      return $this->geo_point_value;
    }
    public function mutableGeoPointValue() {
      if (!isset($this->geo_point_value)) {
        $res = new \google\appengine\datastore\v4\GeoPoint();
        $this->geo_point_value = $res;
        return $res;
      }
      return $this->geo_point_value;
    }
    public function clearGeoPointValue() {
      if (isset($this->geo_point_value)) {
        unset($this->geo_point_value);
      }
    }
    public function hasGeoPointValue() {
      return isset($this->geo_point_value);
    }
    public function getMeaning() {
      if (!isset($this->meaning)) {
        return 0;
      }
      return $this->meaning;
    }
    public function setMeaning($val) {
      $this->meaning = $val;
      return $this;
    }
    public function clearMeaning() {
      unset($this->meaning);
      return $this;
    }
    public function hasMeaning() {
      return isset($this->meaning);
    }
    public function getIndexed() {
      if (!isset($this->indexed)) {
        return true;
      }
      return $this->indexed;
    }
    public function setIndexed($val) {
      $this->indexed = $val;
      return $this;
    }
    public function clearIndexed() {
      unset($this->indexed);
      return $this;
    }
    public function hasIndexed() {
      return isset($this->indexed);
    }
    public function getBlobKeyValue() {
      if (!isset($this->blob_key_value)) {
        return '';
      }
      return $this->blob_key_value;
    }
    public function setBlobKeyValue($val) {
      $this->blob_key_value = $val;
      return $this;
    }
    public function clearBlobKeyValue() {
      unset($this->blob_key_value);
      return $this;
    }
    public function hasBlobKeyValue() {
      return isset($this->blob_key_value);
    }
    public function getStringValue() {
      if (!isset($this->string_value)) {
        return '';
      }
      return $this->string_value;
    }
    public function setStringValue($val) {
      $this->string_value = $val;
      return $this;
    }
    public function clearStringValue() {
      unset($this->string_value);
      return $this;
    }
    public function hasStringValue() {
      return isset($this->string_value);
    }
    public function getBlobValue() {
      if (!isset($this->blob_value)) {
        return '';
      }
      return $this->blob_value;
    }
    public function setBlobValue($val) {
      $this->blob_value = $val;
      return $this;
    }
    public function clearBlobValue() {
      unset($this->blob_value);
      return $this;
    }
    public function hasBlobValue() {
      return isset($this->blob_value);
    }
    public function clear() {
      $this->clearBooleanValue();
      $this->clearIntegerValue();
      $this->clearDoubleValue();
      $this->clearTimestampMicrosecondsValue();
      $this->clearKeyValue();
      $this->clearEntityValue();
      $this->clearListValue();
      $this->clearGeoPointValue();
      $this->clearMeaning();
      $this->clearIndexed();
      $this->clearBlobKeyValue();
      $this->clearStringValue();
      $this->clearBlobValue();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->boolean_value)) {
        $res += 2;
      }
      if (isset($this->integer_value)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->integer_value);
      }
      if (isset($this->double_value)) {
        $res += 9;
      }
      if (isset($this->timestamp_microseconds_value)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->timestamp_microseconds_value);
      }
      if (isset($this->key_value)) {
        $res += 1;
        $res += $this->lengthString($this->key_value->byteSizePartial());
      }
      if (isset($this->entity_value)) {
        $res += 1;
        $res += $this->lengthString($this->entity_value->byteSizePartial());
      }
      $this->checkProtoArray($this->list_value);
      $res += 1 * sizeof($this->list_value);
      foreach ($this->list_value as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->geo_point_value)) {
        $res += 1;
        $res += $this->lengthString($this->geo_point_value->byteSizePartial());
      }
      if (isset($this->meaning)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->meaning);
      }
      if (isset($this->indexed)) {
        $res += 2;
      }
      if (isset($this->blob_key_value)) {
        $res += 2;
        $res += $this->lengthString(strlen($this->blob_key_value));
      }
      if (isset($this->string_value)) {
        $res += 2;
        $res += $this->lengthString(strlen($this->string_value));
      }
      if (isset($this->blob_value)) {
        $res += 2;
        $res += $this->lengthString(strlen($this->blob_value));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->boolean_value)) {
        $out->putVarInt32(8);
        $out->putBoolean($this->boolean_value);
      }
      if (isset($this->integer_value)) {
        $out->putVarInt32(16);
        $out->putVarInt64($this->integer_value);
      }
      if (isset($this->double_value)) {
        $out->putVarInt32(25);
        $out->putDouble($this->double_value);
      }
      if (isset($this->timestamp_microseconds_value)) {
        $out->putVarInt32(32);
        $out->putVarInt64($this->timestamp_microseconds_value);
      }
      if (isset($this->key_value)) {
        $out->putVarInt32(42);
        $out->putVarInt32($this->key_value->byteSizePartial());
        $this->key_value->outputPartial($out);
      }
      if (isset($this->entity_value)) {
        $out->putVarInt32(50);
        $out->putVarInt32($this->entity_value->byteSizePartial());
        $this->entity_value->outputPartial($out);
      }
      $this->checkProtoArray($this->list_value);
      foreach ($this->list_value as $value) {
        $out->putVarInt32(58);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->geo_point_value)) {
        $out->putVarInt32(66);
        $out->putVarInt32($this->geo_point_value->byteSizePartial());
        $this->geo_point_value->outputPartial($out);
      }
      if (isset($this->meaning)) {
        $out->putVarInt32(112);
        $out->putVarInt32($this->meaning);
      }
      if (isset($this->indexed)) {
        $out->putVarInt32(120);
        $out->putBoolean($this->indexed);
      }
      if (isset($this->blob_key_value)) {
        $out->putVarInt32(130);
        $out->putPrefixedString($this->blob_key_value);
      }
      if (isset($this->string_value)) {
        $out->putVarInt32(138);
        $out->putPrefixedString($this->string_value);
      }
      if (isset($this->blob_value)) {
        $out->putVarInt32(146);
        $out->putPrefixedString($this->blob_value);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setBooleanValue($d->getBoolean());
            break;
          case 16:
            $this->setIntegerValue($d->getVarInt64());
            break;
          case 25:
            $this->setDoubleValue($d->getDouble());
            break;
          case 32:
            $this->setTimestampMicrosecondsValue($d->getVarInt64());
            break;
          case 42:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableKeyValue()->tryMerge($tmp);
            break;
          case 50:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableEntityValue()->tryMerge($tmp);
            break;
          case 58:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addListValue()->tryMerge($tmp);
            break;
          case 66:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableGeoPointValue()->tryMerge($tmp);
            break;
          case 112:
            $this->setMeaning($d->getVarInt32());
            break;
          case 120:
            $this->setIndexed($d->getBoolean());
            break;
          case 130:
            $length = $d->getVarInt32();
            $this->setBlobKeyValue(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 138:
            $length = $d->getVarInt32();
            $this->setStringValue(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 146:
            $length = $d->getVarInt32();
            $this->setBlobValue(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (isset($this->key_value) && (!$this->key_value->isInitialized())) return 'key_value';
      if (isset($this->entity_value) && (!$this->entity_value->isInitialized())) return 'entity_value';
      foreach ($this->list_value as $value) {
        if (!$value->isInitialized()) return 'list_value';
      }
      if (isset($this->geo_point_value) && (!$this->geo_point_value->isInitialized())) return 'geo_point_value';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasBooleanValue()) {
        $this->setBooleanValue($x->getBooleanValue());
      }
      if ($x->hasIntegerValue()) {
        $this->setIntegerValue($x->getIntegerValue());
      }
      if ($x->hasDoubleValue()) {
        $this->setDoubleValue($x->getDoubleValue());
      }
      if ($x->hasTimestampMicrosecondsValue()) {
        $this->setTimestampMicrosecondsValue($x->getTimestampMicrosecondsValue());
      }
      if ($x->hasKeyValue()) {
        $this->mutableKeyValue()->mergeFrom($x->getKeyValue());
      }
      if ($x->hasEntityValue()) {
        $this->mutableEntityValue()->mergeFrom($x->getEntityValue());
      }
      foreach ($x->getListValueList() as $v) {
        $this->addListValue()->copyFrom($v);
      }
      if ($x->hasGeoPointValue()) {
        $this->mutableGeoPointValue()->mergeFrom($x->getGeoPointValue());
      }
      if ($x->hasMeaning()) {
        $this->setMeaning($x->getMeaning());
      }
      if ($x->hasIndexed()) {
        $this->setIndexed($x->getIndexed());
      }
      if ($x->hasBlobKeyValue()) {
        $this->setBlobKeyValue($x->getBlobKeyValue());
      }
      if ($x->hasStringValue()) {
        $this->setStringValue($x->getStringValue());
      }
      if ($x->hasBlobValue()) {
        $this->setBlobValue($x->getBlobValue());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->boolean_value) !== isset($x->boolean_value)) return false;
      if (isset($this->boolean_value) && $this->boolean_value !== $x->boolean_value) return false;
      if (isset($this->integer_value) !== isset($x->integer_value)) return false;
      if (isset($this->integer_value) && !$this->integerEquals($this->integer_value, $x->integer_value)) return false;
      if (isset($this->double_value) !== isset($x->double_value)) return false;
      if (isset($this->double_value) && $this->double_value !== $x->double_value) return false;
      if (isset($this->timestamp_microseconds_value) !== isset($x->timestamp_microseconds_value)) return false;
      if (isset($this->timestamp_microseconds_value) && !$this->integerEquals($this->timestamp_microseconds_value, $x->timestamp_microseconds_value)) return false;
      if (isset($this->key_value) !== isset($x->key_value)) return false;
      if (isset($this->key_value) && !$this->key_value->equals($x->key_value)) return false;
      if (isset($this->entity_value) !== isset($x->entity_value)) return false;
      if (isset($this->entity_value) && !$this->entity_value->equals($x->entity_value)) return false;
      if (sizeof($this->list_value) !== sizeof($x->list_value)) return false;
      foreach (array_map(null, $this->list_value, $x->list_value) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->geo_point_value) !== isset($x->geo_point_value)) return false;
      if (isset($this->geo_point_value) && !$this->geo_point_value->equals($x->geo_point_value)) return false;
      if (isset($this->meaning) !== isset($x->meaning)) return false;
      if (isset($this->meaning) && !$this->integerEquals($this->meaning, $x->meaning)) return false;
      if (isset($this->indexed) !== isset($x->indexed)) return false;
      if (isset($this->indexed) && $this->indexed !== $x->indexed) return false;
      if (isset($this->blob_key_value) !== isset($x->blob_key_value)) return false;
      if (isset($this->blob_key_value) && $this->blob_key_value !== $x->blob_key_value) return false;
      if (isset($this->string_value) !== isset($x->string_value)) return false;
      if (isset($this->string_value) && $this->string_value !== $x->string_value) return false;
      if (isset($this->blob_value) !== isset($x->blob_value)) return false;
      if (isset($this->blob_value) && $this->blob_value !== $x->blob_value) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->boolean_value)) {
        $res .= $prefix . "boolean_value: " . $this->debugFormatBool($this->boolean_value) . "\n";
      }
      if (isset($this->integer_value)) {
        $res .= $prefix . "integer_value: " . $this->debugFormatInt64($this->integer_value) . "\n";
      }
      if (isset($this->double_value)) {
        $res .= $prefix . "double_value: " . $this->debugFormatDouble($this->double_value) . "\n";
      }
      if (isset($this->timestamp_microseconds_value)) {
        $res .= $prefix . "timestamp_microseconds_value: " . $this->debugFormatInt64($this->timestamp_microseconds_value) . "\n";
      }
      if (isset($this->key_value)) {
        $res .= $prefix . "key_value <\n" . $this->key_value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->entity_value)) {
        $res .= $prefix . "entity_value <\n" . $this->entity_value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->list_value as $value) {
        $res .= $prefix . "list_value <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->geo_point_value)) {
        $res .= $prefix . "geo_point_value <\n" . $this->geo_point_value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->meaning)) {
        $res .= $prefix . "meaning: " . $this->debugFormatInt32($this->meaning) . "\n";
      }
      if (isset($this->indexed)) {
        $res .= $prefix . "indexed: " . $this->debugFormatBool($this->indexed) . "\n";
      }
      if (isset($this->blob_key_value)) {
        $res .= $prefix . "blob_key_value: " . $this->debugFormatString($this->blob_key_value) . "\n";
      }
      if (isset($this->string_value)) {
        $res .= $prefix . "string_value: " . $this->debugFormatString($this->string_value) . "\n";
      }
      if (isset($this->blob_value)) {
        $res .= $prefix . "blob_value: " . $this->debugFormatString($this->blob_value) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4 {
  class Property extends \google\net\ProtocolMessage {
    private $deprecated_value = array();
    public function getName() {
      if (!isset($this->name)) {
        return '';
      }
      return $this->name;
    }
    public function setName($val) {
      $this->name = $val;
      return $this;
    }
    public function clearName() {
      unset($this->name);
      return $this;
    }
    public function hasName() {
      return isset($this->name);
    }
    public function getDeprecatedMulti() {
      if (!isset($this->deprecated_multi)) {
        return false;
      }
      return $this->deprecated_multi;
    }
    public function setDeprecatedMulti($val) {
      $this->deprecated_multi = $val;
      return $this;
    }
    public function clearDeprecatedMulti() {
      unset($this->deprecated_multi);
      return $this;
    }
    public function hasDeprecatedMulti() {
      return isset($this->deprecated_multi);
    }
    public function getDeprecatedValueSize() {
      return sizeof($this->deprecated_value);
    }
    public function getDeprecatedValueList() {
      return $this->deprecated_value;
    }
    public function mutableDeprecatedValue($idx) {
      if (!isset($this->deprecated_value[$idx])) {
        $val = new \google\appengine\datastore\v4\Value();
        $this->deprecated_value[$idx] = $val;
        return $val;
      }
      return $this->deprecated_value[$idx];
    }
    public function getDeprecatedValue($idx) {
      if (isset($this->deprecated_value[$idx])) {
        return $this->deprecated_value[$idx];
      }
      if ($idx >= end(array_keys($this->deprecated_value))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\datastore\v4\Value();
    }
    public function addDeprecatedValue() {
      $val = new \google\appengine\datastore\v4\Value();
      $this->deprecated_value[] = $val;
      return $val;
    }
    public function clearDeprecatedValue() {
      $this->deprecated_value = array();
    }
    public function getValue() {
      if (!isset($this->value)) {
        return new \google\appengine\datastore\v4\Value();
      }
      return $this->value;
    }
    public function mutableValue() {
      if (!isset($this->value)) {
        $res = new \google\appengine\datastore\v4\Value();
        $this->value = $res;
        return $res;
      }
      return $this->value;
    }
    public function clearValue() {
      if (isset($this->value)) {
        unset($this->value);
      }
    }
    public function hasValue() {
      return isset($this->value);
    }
    public function clear() {
      $this->clearName();
      $this->clearDeprecatedMulti();
      $this->clearDeprecatedValue();
      $this->clearValue();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->name));
      }
      if (isset($this->deprecated_multi)) {
        $res += 2;
      }
      $this->checkProtoArray($this->deprecated_value);
      $res += 1 * sizeof($this->deprecated_value);
      foreach ($this->deprecated_value as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->value)) {
        $res += 1;
        $res += $this->lengthString($this->value->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->name)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->name);
      }
      if (isset($this->deprecated_multi)) {
        $out->putVarInt32(16);
        $out->putBoolean($this->deprecated_multi);
      }
      $this->checkProtoArray($this->deprecated_value);
      foreach ($this->deprecated_value as $value) {
        $out->putVarInt32(26);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->value)) {
        $out->putVarInt32(34);
        $out->putVarInt32($this->value->byteSizePartial());
        $this->value->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 16:
            $this->setDeprecatedMulti($d->getBoolean());
            break;
          case 26:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addDeprecatedValue()->tryMerge($tmp);
            break;
          case 34:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableValue()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->name)) return 'name';
      foreach ($this->deprecated_value as $value) {
        if (!$value->isInitialized()) return 'deprecated_value';
      }
      if (isset($this->value) && (!$this->value->isInitialized())) return 'value';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasName()) {
        $this->setName($x->getName());
      }
      if ($x->hasDeprecatedMulti()) {
        $this->setDeprecatedMulti($x->getDeprecatedMulti());
      }
      foreach ($x->getDeprecatedValueList() as $v) {
        $this->addDeprecatedValue()->copyFrom($v);
      }
      if ($x->hasValue()) {
        $this->mutableValue()->mergeFrom($x->getValue());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->name) !== isset($x->name)) return false;
      if (isset($this->name) && $this->name !== $x->name) return false;
      if (isset($this->deprecated_multi) !== isset($x->deprecated_multi)) return false;
      if (isset($this->deprecated_multi) && $this->deprecated_multi !== $x->deprecated_multi) return false;
      if (sizeof($this->deprecated_value) !== sizeof($x->deprecated_value)) return false;
      foreach (array_map(null, $this->deprecated_value, $x->deprecated_value) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->value) !== isset($x->value)) return false;
      if (isset($this->value) && !$this->value->equals($x->value)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->name)) {
        $res .= $prefix . "name: " . $this->debugFormatString($this->name) . "\n";
      }
      if (isset($this->deprecated_multi)) {
        $res .= $prefix . "deprecated_multi: " . $this->debugFormatBool($this->deprecated_multi) . "\n";
      }
      foreach ($this->deprecated_value as $value) {
        $res .= $prefix . "deprecated_value <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->value)) {
        $res .= $prefix . "value <\n" . $this->value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\datastore\v4 {
  class Entity extends \google\net\ProtocolMessage {
    private $property = array();
    public function getKey() {
      if (!isset($this->key)) {
        return new \google\appengine\datastore\v4\Key();
      }
      return $this->key;
    }
    public function mutableKey() {
      if (!isset($this->key)) {
        $res = new \google\appengine\datastore\v4\Key();
        $this->key = $res;
        return $res;
      }
      return $this->key;
    }
    public function clearKey() {
      if (isset($this->key)) {
        unset($this->key);
      }
    }
    public function hasKey() {
      return isset($this->key);
    }
    public function getPropertySize() {
      return sizeof($this->property);
    }
    public function getPropertyList() {
      return $this->property;
    }
    public function mutableProperty($idx) {
      if (!isset($this->property[$idx])) {
        $val = new \google\appengine\datastore\v4\Property();
        $this->property[$idx] = $val;
        return $val;
      }
      return $this->property[$idx];
    }
    public function getProperty($idx) {
      if (isset($this->property[$idx])) {
        return $this->property[$idx];
      }
      if ($idx >= end(array_keys($this->property))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\datastore\v4\Property();
    }
    public function addProperty() {
      $val = new \google\appengine\datastore\v4\Property();
      $this->property[] = $val;
      return $val;
    }
    public function clearProperty() {
      $this->property = array();
    }
    public function clear() {
      $this->clearKey();
      $this->clearProperty();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->key)) {
        $res += 1;
        $res += $this->lengthString($this->key->byteSizePartial());
      }
      $this->checkProtoArray($this->property);
      $res += 1 * sizeof($this->property);
      foreach ($this->property as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->key)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->key->byteSizePartial());
        $this->key->outputPartial($out);
      }
      $this->checkProtoArray($this->property);
      foreach ($this->property as $value) {
        $out->putVarInt32(18);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableKey()->tryMerge($tmp);
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addProperty()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (isset($this->key) && (!$this->key->isInitialized())) return 'key';
      foreach ($this->property as $value) {
        if (!$value->isInitialized()) return 'property';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasKey()) {
        $this->mutableKey()->mergeFrom($x->getKey());
      }
      foreach ($x->getPropertyList() as $v) {
        $this->addProperty()->copyFrom($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->key) !== isset($x->key)) return false;
      if (isset($this->key) && !$this->key->equals($x->key)) return false;
      if (sizeof($this->property) !== sizeof($x->property)) return false;
      foreach (array_map(null, $this->property, $x->property) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->key)) {
        $res .= $prefix . "key <\n" . $this->key->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->property as $value) {
        $res .= $prefix . "property <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
