/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.stat;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.properties.DoubleProperty;
import net.sourceforge.pmd.properties.IntegerProperty;
import net.sourceforge.pmd.stat.DataPoint;
import net.sourceforge.pmd.stat.Metric;

public abstract class StatisticalRule
extends AbstractRule {
    public static double DELTA = 5.0E-6;
    private SortedSet dataPoints = new TreeSet();
    private int count = 0;
    private double total = 0.0;
    private static final PropertyDescriptor sigmaDescriptor = new DoubleProperty("sigma", "Sigma value", 0.0, 1.0f);
    private static final PropertyDescriptor minimumDescriptor = new DoubleProperty("minimum", "Minimum value", 0.0, 1.0f);
    private static final PropertyDescriptor topScoreDescriptor = new IntegerProperty("topscore", "Top score value", 0, 1.0f);
    private static final Map propertyDescriptorsByName = StatisticalRule.asFixedMap(new PropertyDescriptor[]{sigmaDescriptor, minimumDescriptor, topScoreDescriptor});

    public void addDataPoint(DataPoint point) {
        ++this.count;
        this.total += point.getScore();
        this.dataPoints.add(point);
    }

    public void apply(List acus, RuleContext ctx) {
        double mMin;
        this.visitAll(acus, ctx);
        double minimum = 0.0;
        if (this.hasProperty("sigma")) {
            double deviation = this.getStdDev();
            double sigma = this.getDoubleProperty(sigmaDescriptor);
            minimum = this.getMean() + sigma * deviation;
        }
        if (this.hasProperty("minimum") && (mMin = this.getDoubleProperty(minimumDescriptor)) > minimum) {
            minimum = mMin;
        }
        SortedSet newPoints = this.applyMinimumValue(this.dataPoints, minimum);
        if (this.hasProperty("topscore")) {
            int topScore = this.getIntProperty(topScoreDescriptor);
            if (newPoints.size() >= topScore) {
                newPoints = this.applyTopScore(newPoints, topScore);
            }
        }
        this.makeViolations(ctx, newPoints);
        double low = 0.0;
        double high = 0.0;
        if (!this.dataPoints.isEmpty()) {
            low = ((DataPoint)this.dataPoints.first()).getScore();
            high = ((DataPoint)this.dataPoints.last()).getScore();
        }
        ctx.getReport().addMetric(new Metric(this.getName(), this.count, this.total, low, high, this.getMean(), this.getStdDev()));
        this.dataPoints.clear();
    }

    protected double getMean() {
        return this.total / (double)this.count;
    }

    protected double getStdDev() {
        if (this.dataPoints.size() < 2) {
            return Double.NaN;
        }
        Iterator points = this.dataPoints.iterator();
        double mean = this.getMean();
        double deltaSq = 0.0;
        while (points.hasNext()) {
            double scoreMinusMean = ((DataPoint)points.next()).getScore() - mean;
            deltaSq += scoreMinusMean * scoreMinusMean;
        }
        return Math.sqrt(deltaSq / (double)(this.dataPoints.size() - 1));
    }

    protected SortedSet applyMinimumValue(SortedSet pointSet, double minValue) {
        Iterator points = pointSet.iterator();
        TreeSet<DataPoint> RC = new TreeSet<DataPoint>();
        double threshold = minValue - DELTA;
        while (points.hasNext()) {
            DataPoint point = (DataPoint)points.next();
            if (!(point.getScore() > threshold)) continue;
            RC.add(point);
        }
        return RC;
    }

    protected SortedSet applyTopScore(SortedSet points, int topScore) {
        TreeSet<Object> s = new TreeSet<Object>();
        Object[] arr = points.toArray();
        for (int i = arr.length - 1; i >= arr.length - topScore; --i) {
            s.add(arr[i]);
        }
        return s;
    }

    protected void makeViolations(RuleContext ctx, Set p) {
        Iterator points = p.iterator();
        while (points.hasNext()) {
            DataPoint point = (DataPoint)points.next();
            this.addViolationWithMessage(ctx, point.getNode(), point.getMessage());
        }
    }

    protected Map propertiesByName() {
        return propertyDescriptorsByName;
    }
}

