$('#mysidebar').height($('.nav').height());

// Detect small devices and move the TOC in line
function moveToc() {
    if (window.innerWidth < 1350) {
        $('#toc').detach().appendTo('#inline-toc').removeClass('affix');
    } else {
        $('#toc').detach().appendTo('.toc-col').addClass('affix');
    }
}

$(document).ready(function () {
    $('#toc').toc({
        minimumHeaders: 0,
        listType: 'ul',
        showSpeed: 0,
        headers: 'h2,h3,h4',
    });

    //this script says, if the height of the viewport is greater than 800px, then insert affix class, which makes the nav bar float in a fixed
    // position as your scroll. if you have a lot of nav items, this height may not work for you.
    var h = $(window).height();
    //console.log (h);
    if (h > 600) {
        $('#mysidebar').attr('class', 'nav affix');
    }
    // activate tooltips. although this is a bootstrap js function, it must be activated this way in your theme.
    $('[data-toggle="tooltip"]').tooltip({
        placement: 'top',
    });

    /**
     * AnchorJS
     */
    anchors.add('h2,h3,h4,h5');

    // Add an "Edit on GitHub" button to each header (except h1)
    let url = $('div.post-content').data('githubEditUrl');
    if ( url !== undefined ) {
        $('div.post-content')
            .find(':header:not(h1)')
            .append(
                '  <a class="edit-header" target="_blank" href=' +
                    url +
                    ' role="button">✏️️</a>'
            );
    }

    // Check if TOC needs to be moved on page load
    moveToc();
});

// needed for nav tabs on pages. See Formatting > Nav tabs for more details.
// script from http://stackoverflow.com/questions/10523433/how-do-i-keep-the-current-tab-active-with-twitter-bootstrap-after-a-page-reload
$(function () {
    var json, tabsState;
    $('a[data-toggle="pill"], a[data-toggle="tab"]').on(
        'shown.bs.tab',
        function (e) {
            var href, json, parentId, tabsState;

            tabsState = localStorage.getItem('tabs-state');
            json = JSON.parse(tabsState || '{}');
            parentId = $(e.target)
                .parents('ul.nav.nav-pills, ul.nav.nav-tabs')
                .attr('id');
            href = $(e.target).attr('href');
            json[parentId] = href;

            return localStorage.setItem('tabs-state', JSON.stringify(json));
        }
    );

    tabsState = localStorage.getItem('tabs-state');
    json = JSON.parse(tabsState || '{}');

    $.each(json, function (containerId, href) {
        return $('#' + containerId + ' a[href=' + href + ']').tab('show');
    });

    $('ul.nav.nav-pills, ul.nav.nav-tabs').each(function () {
        var $this = $(this);
        if (!json[$this.attr('id')]) {
            return $this
                .find('a[data-toggle=tab]:first, a[data-toggle=pill]:first')
                .tab('show');
        }
    });
});

// Check if TOC needs to be moved on window resizing
$(window).resize(function () {
    moveToc();
});
