/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.symbol.type.AbstractTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreLists;
import java.util.List;

public class InternalTypeInfo
extends AbstractTypeInfo {
    private final List<String> lookupName = ImmutableList.copyOf(Splitter.on(".").split(this.getApexName().toLowerCase()));
    private final List<TypeInfo> typeArguments;

    private InternalTypeInfo(Builder builder) {
        super(builder);
        this.typeArguments = builder.typeArguments;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public List<TypeInfo> getTypeArguments() {
        return this.typeArguments;
    }

    @Override
    public <T> T accept(TypeInfoVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public List<String> getLookupName() {
        return this.lookupName;
    }

    public static class Builder
    extends AbstractTypeInfo.Builder<Builder, InternalTypeInfo> {
        private List<TypeInfo> typeArguments = ImmutableList.of();

        private Builder() {
        }

        public Builder setTypeArguments(List<TypeInfo> typeArguments) {
            this.typeArguments = typeArguments;
            return this;
        }

        public Builder setTypeArguments(TypeInfo ... typeArguments) {
            return this.setTypeArguments(MoreLists.asImmutableList(typeArguments));
        }

        @Override
        public InternalTypeInfo build() {
            return new InternalTypeInfo(this);
        }
    }
}

