/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.design;

import java.util.Stack;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTUserTrigger;
import net.sourceforge.pmd.lang.apex.metrics.ApexMetrics;
import net.sourceforge.pmd.lang.apex.metrics.api.ApexClassMetricKey;
import net.sourceforge.pmd.lang.apex.metrics.api.ApexOperationMetricKey;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.metrics.MetricKey;
import net.sourceforge.pmd.lang.metrics.MetricsUtil;
import net.sourceforge.pmd.lang.metrics.ResultOption;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.properties.constraints.NumericConstraints;

public class CyclomaticComplexityRule
extends AbstractApexRule {
    private static final PropertyDescriptor<Integer> CLASS_LEVEL_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"classReportLevel").desc("Total class complexity reporting threshold")).require(NumericConstraints.positive())).defaultValue((Object)40)).build();
    private static final PropertyDescriptor<Integer> METHOD_LEVEL_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"methodReportLevel").desc("Cyclomatic complexity reporting threshold")).require(NumericConstraints.positive())).defaultValue((Object)10)).build();
    private Stack<String> classNames = new Stack();
    private boolean inTrigger;

    public CyclomaticComplexityRule() {
        this.definePropertyDescriptor(CLASS_LEVEL_DESCRIPTOR);
        this.definePropertyDescriptor(METHOD_LEVEL_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTUserTrigger node, Object data) {
        this.inTrigger = true;
        super.visit(node, data);
        this.inTrigger = false;
        return data;
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        int classWmc;
        this.classNames.push(node.getImage());
        super.visit(node, data);
        this.classNames.pop();
        if (ApexClassMetricKey.WMC.supports(node) && (classWmc = (int)MetricsUtil.computeMetric((MetricKey)ApexClassMetricKey.WMC, (Node)node)) >= (Integer)this.getProperty(CLASS_LEVEL_DESCRIPTOR)) {
            int classHighest = (int)ApexMetrics.get((MetricKey<ASTMethod>)ApexOperationMetricKey.CYCLO, node, ResultOption.HIGHEST);
            Object[] messageParams = new String[]{"class", node.getImage(), " total", classWmc + " (highest " + classHighest + ")"};
            this.addViolation(data, node, messageParams);
        }
        return data;
    }

    @Override
    public final Object visit(ASTMethod node, Object data) {
        int cyclo;
        if (ApexOperationMetricKey.CYCLO.supports(node) && (cyclo = (int)MetricsUtil.computeMetric((MetricKey)ApexOperationMetricKey.CYCLO, (Node)node)) >= (Integer)this.getProperty(METHOD_LEVEL_DESCRIPTOR)) {
            String opType = this.inTrigger ? "trigger" : (node.getImage().equals(this.classNames.peek()) ? "constructor" : "method");
            this.addViolation(data, node, new String[]{opType, node.getQualifiedName().getOperation(), "", "" + cyclo});
        }
        return data;
    }
}

