/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.bcl.validators;

public class JavaSfdcOnlyAnnotation {
    public static final JavaSfdcOnlyAnnotation DEFAULT_ALLOW_TESTING = JavaSfdcOnlyAnnotation.builder().build();
    private final boolean allowPrivate;
    private final boolean allowInternalSfdc;
    private final boolean allowTrustedApplications;
    private final boolean allowInApexFiles;
    private final boolean allowTesting;
    private final boolean allowOnlyInTesting;
    private final boolean allowOnlyInRealTesting;

    private JavaSfdcOnlyAnnotation(Builder builder) {
        this.allowPrivate = builder.allowPrivate;
        this.allowInternalSfdc = builder.allowInternalSfdc;
        this.allowTrustedApplications = builder.allowTrustedApplications;
        this.allowInApexFiles = builder.allowInApexFiles;
        this.allowTesting = builder.allowTesting;
        this.allowOnlyInTesting = builder.allowOnlyInTesting;
        this.allowOnlyInRealTesting = builder.allowOnlyInRealTesting;
    }

    public boolean isAllowOnlyInTesting() {
        return this.allowOnlyInTesting;
    }

    public boolean isAllowOnlyInRealTesting() {
        return this.allowOnlyInRealTesting;
    }

    public boolean isAllowPrivate() {
        return this.allowPrivate;
    }

    public boolean isAllowInternalSfdc() {
        return this.allowInternalSfdc;
    }

    public boolean isAllowTrustedApplications() {
        return this.allowTrustedApplications;
    }

    public boolean isAllowInApexFiles() {
        return this.allowInApexFiles;
    }

    public boolean isAllowTesting() {
        return this.allowTesting;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean allowPrivate;
        private boolean allowInternalSfdc;
        private boolean allowTrustedApplications;
        private boolean allowInApexFiles;
        private boolean allowTesting = true;
        private boolean allowOnlyInTesting;
        private boolean allowOnlyInRealTesting;

        private Builder() {
        }

        public JavaSfdcOnlyAnnotation build() {
            return new JavaSfdcOnlyAnnotation(this);
        }

        public Builder setAllowPrivate() {
            this.allowPrivate = true;
            return this;
        }

        public Builder setAllowInternalSfdc() {
            this.allowInternalSfdc = true;
            return this;
        }

        public Builder setAllowTrustedApplications() {
            this.allowTrustedApplications = true;
            return this;
        }

        public Builder setAllowInApexFiles() {
            this.allowInApexFiles = true;
            return this;
        }

        public Builder setDisallowTesting() {
            this.allowTesting = false;
            return this;
        }

        public Builder setAllowOnlyInTesting() {
            this.allowOnlyInTesting = true;
            return this;
        }

        public Builder setAllowOnlyInRealTesting() {
            this.allowOnlyInRealTesting = true;
            return this;
        }
    }
}

