/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.symboltable;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.lang.plsql.symboltable.PLSQLNameOccurrence;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.lang.symboltable.Scope;

public class Search {
    private static final Logger LOGGER = Logger.getLogger(Search.class.getName());
    private PLSQLNameOccurrence occ;
    private Set<NameDeclaration> declarations = new HashSet<NameDeclaration>();

    public Search(PLSQLNameOccurrence occ) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("new search for " + (occ.isMethodOrConstructorInvocation() ? "method" : "variable") + " " + occ);
        }
        this.occ = occ;
    }

    public void execute() {
        Set<NameDeclaration> found = this.searchUpward(this.occ, this.occ.getLocation().getScope());
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("found " + found);
        }
        this.declarations.addAll(found);
    }

    public void execute(Scope startingScope) {
        Set<NameDeclaration> found = this.searchUpward(this.occ, startingScope);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("found " + found);
        }
        this.declarations.addAll(found);
    }

    public Set<NameDeclaration> getResult() {
        return this.declarations;
    }

    private Set<NameDeclaration> searchUpward(PLSQLNameOccurrence nameOccurrence, Scope scope) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("checking scope " + scope + " for name occurrence " + nameOccurrence);
        }
        if (!scope.contains((NameOccurrence)nameOccurrence) && scope.getParent() != null) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("moving up fm " + scope + " to " + scope.getParent());
            }
            return this.searchUpward(nameOccurrence, scope.getParent());
        }
        if (scope.contains((NameOccurrence)nameOccurrence)) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("found it!");
            }
            return scope.addNameOccurrence((NameOccurrence)nameOccurrence);
        }
        return new HashSet<NameDeclaration>();
    }
}

