/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.io.Externalizable;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.typeresolution.typedefinition.TypeDefinitionType;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.util.StringUtil;

public class NonSerializableClassRule
extends AbstractJavaRule {
    private static final PropertyDescriptor<String> PREFIX_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.stringProperty((String)"prefix").desc("deprecated! A variable prefix to skip, i.e., m_")).defaultValue((Object)"")).build();
    private static final PropertyDescriptor<Boolean> CHECK_ABSTRACT_TYPES = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"checkAbstractTypes").desc("Enable to verify fields with abstract types like abstract classes, interfaces, generic types or java.lang.Object. Enabling this might lead to more false positives, since the concrete runtime type can actually be serializable.")).defaultValue((Object)false)).build();
    private static final String SERIAL_PERSISTENT_FIELDS_TYPE = "java.io.ObjectStreamField[]";
    private static final String SERIAL_PERSISTENT_FIELDS_NAME = "serialPersistentFields";
    private Map<ASTAnyTypeDeclaration, Set<String>> cachedPersistentFieldNames;

    public NonSerializableClassRule() {
        this.definePropertyDescriptor(PREFIX_DESCRIPTOR);
        this.definePropertyDescriptor(CHECK_ABSTRACT_TYPES);
        this.addRuleChainVisit(ASTVariableDeclaratorId.class);
        this.addRuleChainVisit(ASTTypeDeclaration.class);
    }

    public void start(RuleContext ctx) {
        this.cachedPersistentFieldNames = new HashMap<ASTAnyTypeDeclaration, Set<String>>();
    }

    @Override
    public Object visit(ASTTypeDeclaration node, Object data) {
        ASTAnyTypeDeclaration anyTypeDeclaration = (ASTAnyTypeDeclaration)node.getFirstChildOfType(ASTAnyTypeDeclaration.class);
        for (ASTFieldDeclaration field : anyTypeDeclaration.findDescendantsOfType(ASTFieldDeclaration.class)) {
            for (ASTVariableDeclaratorId varId : field) {
                if (!SERIAL_PERSISTENT_FIELDS_NAME.equals(varId.getName()) || varId.getType() == null || TypeTestUtil.isA(SERIAL_PERSISTENT_FIELDS_TYPE, (TypeNode)varId) && field.isPrivate() && field.isStatic() && field.isFinal()) continue;
                this.asCtx(data).addViolationWithMessage((Node)varId, "The field ''{0}'' should be private static final with type ''{1}''.", new Object[]{varId.getName(), SERIAL_PERSISTENT_FIELDS_TYPE});
            }
        }
        return null;
    }

    @Override
    public Object visit(ASTVariableDeclaratorId node, Object data) {
        ASTAnyTypeDeclaration typeDeclaration = (ASTAnyTypeDeclaration)node.getFirstParentOfType(ASTAnyTypeDeclaration.class);
        if (typeDeclaration == null || !TypeTestUtil.isA(Serializable.class, (TypeNode)typeDeclaration) || TypeTestUtil.isA(Externalizable.class, (TypeNode)typeDeclaration) || this.hasManualSerializationMethod(typeDeclaration)) {
            return null;
        }
        if (this.isPersistentField(typeDeclaration, node) && this.isNotSerializable(node)) {
            this.asCtx(data).addViolation((Node)node, new Object[]{node.getName(), typeDeclaration.getQualifiedName().toString(), this.getTypeName(node.getType())});
        }
        return null;
    }

    private boolean hasManualSerializationMethod(ASTAnyTypeDeclaration node) {
        boolean hasWriteObject = false;
        boolean hasReadObject = false;
        boolean hasWriteReplace = false;
        boolean hasReadResolve = false;
        for (ASTAnyTypeBodyDeclaration decl : node.getDeclarations()) {
            if (decl.getKind() != ASTAnyTypeBodyDeclaration.DeclarationKind.METHOD) continue;
            ASTMethodDeclaration methodDeclaration = (ASTMethodDeclaration)decl.getFirstChildOfType(ASTMethodDeclaration.class);
            String methodName = methodDeclaration.getName();
            int parameterCount = methodDeclaration.getFormalParameters().size();
            ASTFormalParameter firstParameter = (ASTFormalParameter)methodDeclaration.getFormalParameters().getFirstChildOfType(ASTFormalParameter.class);
            ASTType resultType = (ASTType)methodDeclaration.getResultType().getFirstChildOfType(ASTType.class);
            hasWriteObject |= "writeObject".equals(methodName) && parameterCount == 1 && TypeTestUtil.isA(ObjectOutputStream.class, (TypeNode)firstParameter) && resultType == null;
            hasReadObject |= "readObject".equals(methodName) && parameterCount == 1 && TypeTestUtil.isA(ObjectInputStream.class, (TypeNode)firstParameter) && resultType == null;
            hasWriteReplace |= "writeReplace".equals(methodName) && parameterCount == 0 && TypeTestUtil.isExactlyA(Object.class, (TypeNode)resultType);
            hasReadResolve |= "readResolve".equals(methodName) && parameterCount == 0 && TypeTestUtil.isExactlyA(Object.class, (TypeNode)resultType);
        }
        return hasWriteObject && hasReadObject || hasWriteReplace && hasReadResolve;
    }

    private boolean isNotSerializable(TypeNode node) {
        boolean notSerializable;
        Class<?> type = node.getType();
        boolean bl = notSerializable = !TypeTestUtil.isA(Serializable.class, node) && type != null && !type.isPrimitive();
        if (!((Boolean)this.getProperty(CHECK_ABSTRACT_TYPES)).booleanValue() && type != null) {
            notSerializable &= !TypeTestUtil.isExactlyA(Object.class, node) && !type.isInterface() && !Modifier.isAbstract(type.getModifiers()) && !this.isGenericType(node);
        }
        return notSerializable;
    }

    private boolean isGenericType(TypeNode node) {
        ASTClassOrInterfaceType typeRef = (ASTClassOrInterfaceType)((ASTFieldDeclaration)node.getFirstParentOfType(ASTFieldDeclaration.class)).getFirstDescendantOfType(ASTClassOrInterfaceType.class);
        if (typeRef != null && typeRef.getTypeDefinition() != null) {
            return typeRef.getTypeDefinition().getDefinitionType() != TypeDefinitionType.EXACT;
        }
        return false;
    }

    private String getTypeName(Class<?> clazz) {
        return clazz != null ? clazz.getName() : "<unknown>";
    }

    private Set<String> determinePersistentFields(ASTAnyTypeDeclaration typeDeclaration) {
        if (this.cachedPersistentFieldNames.containsKey(typeDeclaration)) {
            return this.cachedPersistentFieldNames.get(typeDeclaration);
        }
        ASTVariableDeclarator persistentFieldsDecl = null;
        for (Object field : typeDeclaration.findDescendantsOfType(ASTFieldDeclaration.class)) {
            if (!TypeTestUtil.isA(SERIAL_PERSISTENT_FIELDS_TYPE, (TypeNode)field) || !((ASTFieldDeclaration)field).isPrivate() || !((ASTFieldDeclaration)field).isStatic() || !((ASTFieldDeclaration)field).isFinal()) continue;
            Iterator<ASTVariableDeclaratorId> iterator = ((ASTFieldDeclaration)field).iterator();
            while (iterator.hasNext()) {
                ASTVariableDeclaratorId varId = iterator.next();
                if (!SERIAL_PERSISTENT_FIELDS_NAME.equals(varId.getName())) continue;
                persistentFieldsDecl = (ASTVariableDeclarator)varId.getFirstParentOfType(ASTVariableDeclarator.class);
            }
        }
        HashSet<String> fields = null;
        if (persistentFieldsDecl != null) {
            ASTName reference;
            fields = new HashSet<String>();
            for (ASTLiteral literal : persistentFieldsDecl.findDescendantsOfType(ASTLiteral.class)) {
                if (!literal.isStringLiteral()) continue;
                fields.add(StringUtil.removeDoubleQuotes((String)literal.getImage()));
            }
            if (fields.isEmpty() && (reference = (ASTName)persistentFieldsDecl.getFirstDescendantOfType(ASTName.class)) != null && reference.getNameDeclaration() != null) {
                for (ASTLiteral literal : reference.getNameDeclaration().getNode().getParent().findDescendantsOfType(ASTLiteral.class)) {
                    if (!literal.isStringLiteral()) continue;
                    fields.add(StringUtil.removeDoubleQuotes((String)literal.getImage()));
                }
            }
        }
        this.cachedPersistentFieldNames.put(typeDeclaration, fields);
        return fields;
    }

    private boolean isPersistentField(ASTAnyTypeDeclaration typeDeclaration, ASTVariableDeclaratorId node) {
        Set<String> persistentFields = this.determinePersistentFields(typeDeclaration);
        if (node.isField() && (persistentFields == null || persistentFields.contains(node.getName()))) {
            ASTFieldDeclaration field = (ASTFieldDeclaration)node.getFirstParentOfType(ASTFieldDeclaration.class);
            return !field.isStatic() && !field.isTransient();
        }
        return false;
    }
}

