/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.common.base.WeakStringInterner;
import apex.jorje.data.Identifier;
import apex.jorje.data.Identifiers;
import apex.jorje.data.Location;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.symbol.member.variable.ConstantValue;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.naming.TypeEraser;
import com.google.common.base.MoreObjects;
import java.util.Optional;

public abstract class AbstractFieldInfo
implements FieldInfo {
    static final String STATIC_NAME_STRING = "_static_";
    private final String name;
    private final String bytecodeName;
    private final Location loc;
    private final TypeInfo definingType;
    private final TypeInfo type;
    private final ModifierGroup modifiers;
    private final Object value;
    private final TypeInfo emitType;

    AbstractFieldInfo(Builder<? extends Builder, ? extends AbstractFieldInfo> builder) {
        this.type = ((Builder)builder).type;
        this.name = WeakStringInterner.get().intern(((Builder)builder).name.getValue());
        this.bytecodeName = WeakStringInterner.get().intern(((Builder)builder).bytecodeName);
        this.loc = ((Builder)builder).name.getLoc();
        this.modifiers = ((Builder)builder).modifiers;
        this.value = ((Builder)builder).value;
        this.definingType = ((Builder)builder).definingType;
        this.emitType = ((Builder)builder).emitType;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("bytecodeName", this.bytecodeName).add("loc", this.loc).add("definingType", this.definingType).add("type", this.type).add("modifiers", this.modifiers).add("value", this.value).toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.definingType;
    }

    @Override
    public ModifierGroup getModifiers() {
        return this.modifiers;
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    @Override
    public TypeInfo getEmitType() {
        return this.emitType;
    }

    @Override
    public String getBytecodeName() {
        return this.bytecodeName;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    public static abstract class Builder<B extends Builder, Field extends AbstractFieldInfo> {
        private Identifier name;
        private String bytecodeName;
        private ModifierGroup modifiers;
        private TypeInfo type;
        private TypeRef typeRef;
        private Object value;
        private TypeInfo definingType;
        private TypeInfo emitType;

        public Location getLoc() {
            return this.name.getLoc();
        }

        public TypeRef getTypeRef() {
            return this.typeRef;
        }

        public B setTypeRef(TypeRef typeRef) {
            assert (this.type == null);
            this.typeRef = typeRef;
            return (B)this;
        }

        public B setName(String name) {
            return this.setName(Identifiers.newIdentifier(name));
        }

        public B setName(Identifier name) {
            this.name = name;
            return (B)this;
        }

        public B setType(TypeInfo type) {
            assert (this.typeRef == null);
            this.type = type;
            return (B)this;
        }

        public ModifierGroup getModifiers() {
            return this.modifiers;
        }

        public B setModifiers(ModifierGroup modifiers) {
            this.modifiers = modifiers;
            return (B)this;
        }

        public B setValue(Optional<Expr> assignment) {
            this.value = ConstantValue.get(assignment);
            return (B)this;
        }

        public B setDefiningType(TypeInfo classType) {
            this.definingType = classType;
            return (B)this;
        }

        public Field build() {
            return this.buildWorker(null);
        }

        public Field build(SymbolResolver symbols) {
            return this.buildWorker(symbols);
        }

        protected abstract Field creator();

        private Field buildWorker(SymbolResolver symbols) {
            assert (this.type != null || this.typeRef != null) : "type not set";
            assert (this.name != null) : "name not set";
            assert (this.modifiers != null) : "modifiers not set";
            assert (this.definingType != null) : "defining type not set";
            if (this.type == null) {
                assert (symbols != null);
                this.type = symbols.lookupTypeInfo(this.definingType, this.typeRef);
            }
            this.emitType = TypeEraser.eraseType(symbols, this.type);
            if (this.bytecodeName == null) {
                switch (this.definingType.getUnitType()) {
                    case TRIGGER: 
                    case ENUM: {
                        this.bytecodeName = this.name.getValue();
                        break;
                    }
                    default: {
                        String calculatedBytecodeName = this.modifiers.has(ModifierTypeInfos.STATIC) ? AbstractFieldInfo.STATIC_NAME_STRING + this.name.getValue() : this.name.getValue();
                        this.bytecodeName = WeakStringInterner.get().intern(calculatedBytecodeName);
                    }
                }
            }
            return this.creator();
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("bytecodeName", this.bytecodeName).add("name", this.name).add("modifiers", this.modifiers).add("type", this.type).add("typeRef", this.typeRef).add("value", this.value).add("definingType", this.definingType).add("emitType", this.emitType).toString();
        }
    }
}

