/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.common.base.MoreStrings;
import apex.common.collect.MoreIterables;
import apex.jorje.data.Identifier;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.expression.ReferenceType;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.BooleanScope;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.SObjectFieldInfo;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.services.Version;
import java.util.List;

class ListCreatorVisitors {
    static final ListCreatorVisitors INSTANCE = new ListCreatorVisitors();
    private static final AstVisitor<BooleanScope> IS_GET_SOBJECTS = new AstVisitor<BooleanScope>(){

        @Override
        public void visitEnd(MethodCallExpression node, BooleanScope scope) {
            MethodInfo method = node.getMethod().get();
            scope.setValue(method.getDefiningType().getBasicType() == BasicType.SOBJECT && method.getName().equalsIgnoreCase("getSObjects"));
        }
    };
    private static final AstVisitor<BooleanScope> IS_DATABASE_QUERY = new AstVisitor<BooleanScope>(){

        @Override
        public void visitEnd(MethodCallExpression node, BooleanScope scope) {
            MethodInfo method = node.getMethod().get();
            scope.setValue(TypeInfoEquivalence.isEquivalent(InternalTypeInfos.DATABASE, method.getDefiningType()) && method.getName().equalsIgnoreCase("query") && !ListCreatorVisitors.firstIdentifierIsSystem(node.getReferenceContext().getNames()));
        }
    };
    private static final AstVisitor<BooleanScope> IS_SYSTEM_DATABASE_QUERY = new AstVisitor<BooleanScope>(){

        @Override
        public void visitEnd(MethodCallExpression node, BooleanScope scope) {
            MethodInfo method = node.getMethod().get();
            scope.setValue(TypeInfoEquivalence.isEquivalent(InternalTypeInfos.DATABASE, method.getDefiningType()) && method.getName().equalsIgnoreCase("query") && ListCreatorVisitors.firstIdentifierIsSystem(node.getReferenceContext().getNames()));
        }
    };
    private static final VariableVisitor<Boolean, Void> IS_AGGREGATE_FIELD = new VariableVisitor.Default<Boolean, Void>(){

        @Override
        public Boolean _default(Variable info, Void context) {
            return false;
        }

        @Override
        public Boolean visit(SObjectFieldInfo info, Void context) {
            return info.getCategory() == SObjectFieldInfo.Category.AGGREGATE;
        }
    };
    private static final AstVisitor<BooleanScope> IS_AGGREGATE_EXPRESSION = new AstVisitor<BooleanScope>(){

        @Override
        public void visitEnd(VariableExpression node, BooleanScope scope) {
            if (node.getReferenceType() == ReferenceType.LOAD) {
                scope.setValue((Boolean)node.getVariable().accept(IS_AGGREGATE_FIELD, VariableVisitor.Context.NONE));
            }
        }
    };

    private ListCreatorVisitors() {
    }

    private static boolean firstIdentifierIsSystem(List<Identifier> names) {
        return MoreStrings.equalsIgnoreCase(MoreIterables.getFirst(names).getValue(), Namespaces.SYSTEM.getGlobal());
    }

    boolean isGetSObjects(Expression expression) {
        return BooleanScope.evaluate(expression, IS_GET_SOBJECTS, false);
    }

    boolean isDatabaseQuery(Expression expression) {
        return BooleanScope.evaluate(expression, IS_DATABASE_QUERY, false);
    }

    boolean isSystemDatabaseQuery(Expression expression) {
        return BooleanScope.evaluate(expression, IS_SYSTEM_DATABASE_QUERY, false);
    }

    boolean isAggregateField(Expression expression) {
        return BooleanScope.evaluate(expression, IS_AGGREGATE_EXPRESSION, false);
    }

    Version getExpressionVersion(Expression expression) {
        return expression.getDefiningType().getCodeUnitDetails().getVersion();
    }
}

