/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.services.I18nSupport;

class ScriptTooLargeValidator {
    static final int MAX_LENGTH_CLASS = 1000000;
    static final int MAX_LENGTH_ANONYMOUS = 32000;
    static final int MAX_LENGTH_ANONYMOUS_UNDER_TEST = 3200000;

    ScriptTooLargeValidator() {
    }

    static boolean isScriptTooLarge(TypeInfo typeInfo, AccessEvaluator accessEvaluator) {
        int maxLengthAllowed;
        int lengthWithComments = typeInfo.getCodeUnitDetails().getSource().getLengthWithComments();
        return lengthWithComments > (maxLengthAllowed = ScriptTooLargeValidator.getMaxLengthAllowed(typeInfo.getUnitType(), accessEvaluator));
    }

    static String createScriptTooLargeError(SourceFile sourceFile) {
        return I18nSupport.getLabel("script.too.large", sourceFile.getBody().substring(0, Math.min(sourceFile.getBody().length(), 100)));
    }

    static int getMaxLengthAllowed(UnitType unitType, AccessEvaluator accessEvaluator) {
        if (unitType == UnitType.ANONYMOUS) {
            return accessEvaluator.useTestValueForAnonymousScriptLengthLimit() ? 3200000 : 32000;
        }
        return 1000000;
    }
}

