/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.visitors;

import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.statement.BlockStatement;
import apex.jorje.semantic.ast.statement.CatchBlockStatement;
import apex.jorje.semantic.ast.statement.ForEachStatement;
import apex.jorje.semantic.ast.statement.ForLoopStatement;
import apex.jorje.semantic.ast.statement.IfElseBlockStatement;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.statement.TypeWhenBlock;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.NoopScope;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import java.util.Optional;

public class LocalInfoScopeVisitor
extends AstVisitor<NoopScope> {
    private Optional<Statement> containingBlock;
    private final LocalInfo localInfo;

    public LocalInfoScopeVisitor(LocalInfo localInfo) {
        this.localInfo = localInfo;
        this.containingBlock = Optional.empty();
    }

    @Override
    protected boolean defaultVisit() {
        return true;
    }

    @Override
    public void visitEnd(BlockStatement blockStatement, NoopScope scope) {
        super.visitEnd(blockStatement, scope);
        if (blockStatement.getLocals().all().contains(this.localInfo)) {
            this.containingBlock = Optional.of(blockStatement);
        }
    }

    @Override
    public void visitEnd(CatchBlockStatement catchStatement, NoopScope scope) {
        super.visitEnd(catchStatement, scope);
        if (catchStatement.getLocals().all().contains(this.localInfo)) {
            this.containingBlock = Optional.of(catchStatement);
        }
    }

    @Override
    public void visitEnd(ForEachStatement forEachStatement, NoopScope scope) {
        super.visitEnd(forEachStatement, scope);
        if (forEachStatement.getLocals().all().contains(this.localInfo)) {
            this.containingBlock = Optional.of(forEachStatement);
        }
    }

    @Override
    public void visitEnd(ForLoopStatement forLoopStatement, NoopScope scope) {
        super.visitEnd(forLoopStatement, scope);
        if (forLoopStatement.getLocals().all().contains(this.localInfo)) {
            this.containingBlock = Optional.of(forLoopStatement);
        }
    }

    @Override
    public void visitEnd(IfElseBlockStatement ifElseBlockStatement, NoopScope scope) {
        super.visitEnd(ifElseBlockStatement, scope);
        if (ifElseBlockStatement.getLocals().all().contains(this.localInfo)) {
            this.containingBlock = Optional.of(ifElseBlockStatement);
        }
    }

    @Override
    public void visitEnd(TypeWhenBlock typeWhenBlock, NoopScope scope) {
        super.visitEnd(typeWhenBlock, scope);
        if (typeWhenBlock.getLocals().all().contains(this.localInfo)) {
            this.containingBlock = Optional.of(typeWhenBlock.getBlock());
        }
    }

    @Override
    public void visitEnd(Method method, NoopScope scope) {
        super.visitEnd(method, scope);
        if (method.getLocals().all().contains(this.localInfo)) {
            this.containingBlock = Optional.of(method.getBody());
        }
    }

    public Optional<Statement> getContainingBlock() {
        return this.containingBlock;
    }
}

