/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties.modules;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.properties.modules.PackagedPropertyModule;
import net.sourceforge.pmd.util.ClassUtil;

@Deprecated
public class MethodPropertyModule
extends PackagedPropertyModule<Method> {
    public static final char CLASS_METHOD_DELIMITER = '#';
    public static final char METHOD_ARG_DELIMITER = ',';
    public static final char[] METHOD_GROUP_DELIMITERS = new char[]{'(', ')'};
    public static final String ARRAY_FLAG = "[]";
    private static final Map<Class<?>, String> TYPE_SHORTCUTS = ClassUtil.getClassShortNames();

    public MethodPropertyModule(String[] legalPackageNames, List<Method> defaults) {
        super(legalPackageNames, defaults);
    }

    @Override
    protected String packageNameOf(Method method) {
        return method.getDeclaringClass().getName() + '.' + method.getName();
    }

    @Override
    protected String itemTypeName() {
        return "method";
    }

    public static String asString(Method method) {
        return method == null ? "" : MethodPropertyModule.asStringFor(method);
    }

    private static String asStringFor(Method method) {
        StringBuilder sb = new StringBuilder();
        MethodPropertyModule.asStringOn(method, sb);
        return sb.toString();
    }

    private static void asStringOn(Method method, StringBuilder sb) {
        Class<?> clazz = method.getDeclaringClass();
        sb.append(MethodPropertyModule.shortestNameFor(clazz));
        sb.append('#');
        sb.append(method.getName());
        sb.append(METHOD_GROUP_DELIMITERS[0]);
        Class<?>[] argTypes = method.getParameterTypes();
        if (argTypes.length == 0) {
            sb.append(METHOD_GROUP_DELIMITERS[1]);
            return;
        }
        MethodPropertyModule.serializedTypeIdOn(argTypes[0], sb);
        for (int i = 1; i < argTypes.length; ++i) {
            sb.append(',');
            MethodPropertyModule.serializedTypeIdOn(argTypes[i], sb);
        }
        sb.append(METHOD_GROUP_DELIMITERS[1]);
    }

    private static String shortestNameFor(Class<?> cls) {
        String compactName = TYPE_SHORTCUTS.get(cls);
        return compactName == null ? cls.getName() : compactName;
    }

    private static void serializedTypeIdOn(Class<?> type, StringBuilder sb) {
        Class<?> arrayType = type.getComponentType();
        if (arrayType == null) {
            sb.append(MethodPropertyModule.shortestNameFor(type));
            return;
        }
        sb.append(MethodPropertyModule.shortestNameFor(arrayType)).append(ARRAY_FLAG);
    }
}

