/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.parser.impl;

import apex.jorje.data.Location;
import apex.jorje.parser.impl.ApexLexer;
import apex.jorje.parser.impl.HiddenToken;
import apex.jorje.parser.impl.HiddenTokens;
import apex.jorje.parser.impl.TokenSourceDecorator;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.antlr.runtime.Token;

public class HiddenTokenDecorator
implements TokenSourceDecorator {
    private static final Predicate<Token> HIDDEN_CHANNEL_PREDICATE = token -> 99 == token.getChannel();
    private static final Predicate<Token> COMMENT_PREDICATE = token -> 17 == token.getType() || 59 == token.getType();
    private final ApexLexer apexLexer;
    private final NavigableMap<Integer, HiddenToken> hiddenTokenMap;

    public HiddenTokenDecorator(ApexLexer apexLexer) {
        this.apexLexer = Objects.requireNonNull(apexLexer);
        this.hiddenTokenMap = new TreeMap<Integer, HiddenToken>();
    }

    public Token nextToken() {
        Token nextToken = this.apexLexer.nextToken();
        this.createHiddenToken(nextToken, HIDDEN_CHANNEL_PREDICATE.and(COMMENT_PREDICATE));
        return nextToken;
    }

    public String getSourceName() {
        return this.apexLexer.getSourceName();
    }

    private void createHiddenToken(Token nextToken, Predicate<Token> predicate) {
        if (predicate.test(nextToken)) {
            Location loc = this.apexLexer.createCurrentLoc();
            Optional<HiddenToken> hiddenTokenOptional = HiddenTokens.HiddenTokenFactory.createHiddenToken(nextToken.getType(), nextToken.getText(), loc);
            hiddenTokenOptional.ifPresent(hiddenToken -> this.hiddenTokenMap.put(loc.getStartIndex(), (HiddenToken)hiddenToken));
        }
    }

    @Override
    public NavigableMap<Integer, HiddenToken> getHiddenTokenMap() {
        return this.hiddenTokenMap;
    }
}

