/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDVersion;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.renderers.AbstractIncrementingRenderer;
import net.sourceforge.pmd.renderers.CodeClimateIssue;
import net.sourceforge.pmd.renderers.CodeClimateRule;
import org.apache.commons.lang3.StringUtils;

public class CodeClimateRenderer
extends AbstractIncrementingRenderer {
    public static final String NAME = "codeclimate";
    public static final String BODY_PLACEHOLDER = "REPLACE_THIS_WITH_MARKDOWN";
    public static final int REMEDIATION_POINTS_DEFAULT = 50000;
    public static final String[] CODECLIMATE_DEFAULT_CATEGORIES = new String[]{"Style"};
    protected static final String NULL_CHARACTER = "\u0000";
    protected static final List<String> INTERNAL_DEV_PROPERTIES = Arrays.asList("version", "xpath");
    private static final String PMD_PROPERTIES_URL = CodeClimateRenderer.getPmdPropertiesURL();
    private Rule rule;

    public CodeClimateRenderer() {
        super(NAME, "Code Climate integration.");
    }

    private static String getPmdPropertiesURL() {
        String PAGE = "/pmd_userdocs_configuring_rules.html#rule-properties";
        String url = "https://pmd.github.io/pmd-" + PMDVersion.VERSION + "/pmd_userdocs_configuring_rules.html#rule-properties";
        if (PMDVersion.isSnapshot() || PMDVersion.isUnknown()) {
            url = "https://pmd.github.io/latest/pmd_userdocs_configuring_rules.html#rule-properties";
        }
        return url;
    }

    @Override
    public void renderFileViolations(Iterator<RuleViolation> violations) throws IOException {
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        while (violations.hasNext()) {
            RuleViolation rv = violations.next();
            this.rule = rv.getRule();
            String json = gson.toJson((Object)this.asIssue(rv));
            json = json.replace(BODY_PLACEHOLDER, this.getBody());
            this.writer.write(json + NULL_CHARACTER + PMD.EOL);
        }
    }

    private CodeClimateIssue asIssue(RuleViolation rv) {
        CodeClimateIssue issue = new CodeClimateIssue();
        issue.check_name = this.rule.getName();
        issue.description = this.cleaned(rv.getDescription());
        issue.content = new CodeClimateIssue.Content(BODY_PLACEHOLDER);
        issue.location = this.getLocation(rv);
        issue.remediation_points = this.getRemediationPoints();
        issue.categories = this.getCategories();
        switch (this.rule.getPriority()) {
            case HIGH: {
                issue.severity = "blocker";
                break;
            }
            case MEDIUM_HIGH: {
                issue.severity = "critical";
                break;
            }
            case MEDIUM: {
                issue.severity = "major";
                break;
            }
            case MEDIUM_LOW: {
                issue.severity = "minor";
                break;
            }
            default: {
                issue.severity = "info";
            }
        }
        return issue;
    }

    @Override
    public String defaultFileExtension() {
        return "json";
    }

    private CodeClimateIssue.Location getLocation(RuleViolation rv) {
        String pathWithoutCcRoot = StringUtils.removeStartIgnoreCase((String)this.determineFileName(rv.getFilename()), (String)"/code/");
        CodeClimateIssue.Location result = this.rule.hasDescriptor(CodeClimateRule.CODECLIMATE_REMEDIATION_MULTIPLIER) && this.rule.getProperty(CodeClimateRule.CODECLIMATE_BLOCK_HIGHLIGHTING) == false ? new CodeClimateIssue.Location(pathWithoutCcRoot, rv.getBeginLine(), rv.getBeginLine()) : new CodeClimateIssue.Location(pathWithoutCcRoot, rv.getBeginLine(), rv.getEndLine());
        return result;
    }

    private int getRemediationPoints() {
        int remediationPoints = 50000;
        if (this.rule.hasDescriptor(CodeClimateRule.CODECLIMATE_REMEDIATION_MULTIPLIER)) {
            remediationPoints *= this.rule.getProperty(CodeClimateRule.CODECLIMATE_REMEDIATION_MULTIPLIER).intValue();
        }
        return remediationPoints;
    }

    private String[] getCategories() {
        String[] result;
        if (this.rule.hasDescriptor(CodeClimateRule.CODECLIMATE_CATEGORIES)) {
            List categories = (List)((Object)this.rule.getProperty(CodeClimateRule.CODECLIMATE_CATEGORIES));
            result = categories.toArray(new String[0]);
        } else {
            result = CODECLIMATE_DEFAULT_CATEGORIES;
        }
        return result;
    }

    private <T> String getBody() {
        StringBuilder result = new StringBuilder();
        result.append("## ").append(this.rule.getName()).append("\\n\\n").append("Since: PMD ").append(this.rule.getSince()).append("\\n\\n").append("Priority: ").append((Object)this.rule.getPriority()).append("\\n\\n").append("[Categories](https://github.com/codeclimate/platform/blob/master/spec/analyzers/SPEC.md#categories): ").append(Arrays.toString(this.getCategories()).replaceAll("[\\[\\]]", "")).append("\\n\\n").append("[Remediation Points](https://github.com/codeclimate/platform/blob/master/spec/analyzers/SPEC.md#remediation-points): ").append(this.getRemediationPoints()).append("\\n\\n").append(this.cleaned(this.rule.getDescription()));
        if (!this.rule.getExamples().isEmpty()) {
            result.append("\\n\\n### Example:\\n\\n");
            for (String string : this.rule.getExamples()) {
                String exampleSnippet = string.replaceAll("\\n", "\\\\n");
                exampleSnippet = exampleSnippet.replaceAll("\\t", "\\\\t");
                result.append("```java\\n").append(exampleSnippet).append("\\n```  ");
            }
        }
        if (!this.rule.getPropertyDescriptors().isEmpty()) {
            result.append("\\n\\n### [PMD properties](").append(PMD_PROPERTIES_URL).append(")\\n\\n");
            result.append("Name | Value | Description\\n");
            result.append("--- | --- | ---\\n");
            for (PropertyDescriptor propertyDescriptor : this.rule.getPropertyDescriptors()) {
                String propertyName = propertyDescriptor.name().replaceAll("\\_", "\\\\_");
                if (INTERNAL_DEV_PROPERTIES.contains(propertyName)) continue;
                PropertyDescriptor typed = propertyDescriptor;
                Object value = this.rule.getProperty(typed);
                String propertyValue = typed.asDelimitedString(value);
                if (propertyValue == null) {
                    propertyValue = "";
                }
                propertyValue = propertyValue.replaceAll("(\n|\r\n|\r)", "\\\\n");
                result.append(propertyName).append(" | ").append(propertyValue).append(" | ").append(propertyDescriptor.description()).append("\\n");
            }
        }
        return this.cleaned(result.toString());
    }

    private String cleaned(String original) {
        String result = original.trim();
        result = result.replaceAll("\\s+", " ");
        result = result.replaceAll("\\s*[\\r\\n]+\\s*", "");
        result = result.replaceAll("\"", "'");
        return result;
    }
}

