/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.layouters;

import java.util.Collection;
import java.util.TreeSet;
import org.openjdk.jol.datamodel.CurrentDataModel;
import org.openjdk.jol.info.ClassData;
import org.openjdk.jol.info.ClassLayout;
import org.openjdk.jol.info.FieldData;
import org.openjdk.jol.info.FieldLayout;
import org.openjdk.jol.layouters.Layouter;
import org.openjdk.jol.util.MathUtil;
import org.openjdk.jol.util.VMSupport;

public class CurrentLayouter
implements Layouter {
    @Override
    public ClassLayout layout(ClassData data) {
        int instanceSize;
        CurrentDataModel model = new CurrentDataModel();
        if (data.isArray()) {
            try {
                int base = VMSupport.U.arrayBaseOffset(Class.forName(data.arrayClass()));
                int scale = VMSupport.U.arrayIndexScale(Class.forName(data.arrayClass()));
                int instanceSize2 = MathUtil.align(base + data.arrayLength() * scale, model.objectAlignment());
                TreeSet<FieldLayout> treeSet = new TreeSet<FieldLayout>();
                treeSet.add(new FieldLayout(FieldData.create(data.arrayClass(), "<elements>", data.arrayComponentType()), base, scale * data.arrayLength()));
                return new ClassLayout(data, treeSet, model.arrayHeaderSize(), instanceSize2, false);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Should not reach here.", e);
            }
        }
        Collection<FieldData> fields = data.fields();
        TreeSet<FieldLayout> result = new TreeSet<FieldLayout>();
        for (FieldData fieldData : fields) {
            result.add(new FieldLayout(fieldData, fieldData.vmOffset(), model.sizeOf(fieldData.typeClass())));
        }
        if (result.isEmpty()) {
            instanceSize = model.headerSize();
        } else {
            FieldLayout fieldLayout = (FieldLayout)result.last();
            instanceSize = fieldLayout.offset() + fieldLayout.size();
        }
        instanceSize = MathUtil.align(instanceSize, model.objectAlignment());
        return new ClassLayout(data, result, model.headerSize(), instanceSize, true);
    }

    public String toString() {
        return "Current VM Layout";
    }
}

