/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.symboltable;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.lang.plsql.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLParserVisitorAdapter;
import net.sourceforge.pmd.lang.plsql.symboltable.NameFinder;
import net.sourceforge.pmd.lang.plsql.symboltable.PLSQLNameOccurrence;
import net.sourceforge.pmd.lang.plsql.symboltable.Search;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.Scope;

public class OccurrenceFinder
extends PLSQLParserVisitorAdapter {
    private static final Logger LOGGER = Logger.getLogger(OccurrenceFinder.class.getName());

    @Override
    public Object visit(ASTPrimaryExpression node, Object data) {
        NameFinder nameFinder = new NameFinder(node);
        HashSet<Object> declarations = new HashSet<Object>();
        List<PLSQLNameOccurrence> names = nameFinder.getNames();
        for (PLSQLNameOccurrence occ : names) {
            Search search = new Search(occ);
            if (declarations.isEmpty()) {
                search.execute();
                declarations.addAll(search.getResult());
                if (!declarations.isEmpty()) continue;
                break;
            }
            HashSet<NameDeclaration> additionalDeclarations = new HashSet<NameDeclaration>();
            for (NameDeclaration nameDeclaration : declarations) {
                Scope scope = nameDeclaration.getScope();
                if (null == scope) {
                    if (!LOGGER.isLoggable(Level.FINEST)) break;
                    LOGGER.finest("NameOccurrence has no Scope:" + nameDeclaration.getClass().getCanonicalName() + "=>" + nameDeclaration.getImage());
                    break;
                }
                search.execute(scope);
                Set<NameDeclaration> found = search.getResult();
                additionalDeclarations.addAll(found);
                if (!found.isEmpty()) continue;
                break;
            }
            declarations.addAll(additionalDeclarations);
        }
        return super.visit(node, data);
    }
}

