/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver.rules;

import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.resolver.StandardSymbolResolver;
import apex.jorje.semantic.symbol.resolver.rules.FourPartTypeNameResolveRule;
import apex.jorje.semantic.symbol.resolver.rules.OnePartTypeNameResolveRule;
import apex.jorje.semantic.symbol.resolver.rules.ThreePartTypeNameResolveRule;
import apex.jorje.semantic.symbol.resolver.rules.TwoPartTypeNameResolveRule;
import apex.jorje.semantic.symbol.resolver.rules.TypeNameResolutionOrder;
import apex.jorje.semantic.symbol.type.TypeInfo;
import java.util.List;

public class TypeNameResolutionOrderUtil {
    private static final TypeNameResolutionOrderUtil INSTANCE = new TypeNameResolutionOrderUtil();

    private TypeNameResolutionOrderUtil() {
    }

    public static TypeNameResolutionOrderUtil get() {
        return INSTANCE;
    }

    public TypeInfo bindToType(StandardSymbolResolver symbols, TypeInfo referencingType, TypeNameResolutionOrder order, List<String> names) {
        switch (names.size()) {
            case 1: {
                return this.getTypeFromOnePartRules(symbols, referencingType, order, names.get(0).toLowerCase());
            }
            case 2: {
                return this.getTypeFromTwoPartRules(symbols, referencingType, order, names.get(0).toLowerCase(), names.get(1).toLowerCase());
            }
            case 3: {
                return this.getTypeFromThreePartRules(symbols, referencingType, order, names.get(0).toLowerCase(), names.get(1).toLowerCase(), names.get(2).toLowerCase());
            }
            case 4: {
                return this.getTypeFromFourPartRules(symbols, referencingType, order, names.get(0).toLowerCase(), names.get(1).toLowerCase(), names.get(2).toLowerCase(), names.get(3).toLowerCase());
            }
        }
        throw new UnexpectedCodePathException();
    }

    TypeInfo getTypeFromOnePartRules(StandardSymbolResolver symbols, TypeInfo referencingType, TypeNameResolutionOrder order, String firstPart) {
        for (OnePartTypeNameResolveRule rule : order.getOnePartRules()) {
            TypeInfo type;
            if (referencingType.getCodeUnitDetails().getVersion().isGreaterThan(rule.getMaxVersion()) || (type = rule.lookup(symbols, referencingType, firstPart)) == null) continue;
            return type;
        }
        return null;
    }

    TypeInfo getTypeFromTwoPartRules(StandardSymbolResolver symbols, TypeInfo referencingType, TypeNameResolutionOrder order, String firstPart, String secondPart) {
        for (TwoPartTypeNameResolveRule rule : order.getTwoPartRules()) {
            TypeInfo type;
            if (referencingType.getCodeUnitDetails().getVersion().isGreaterThan(rule.getMaxVersion()) || (type = rule.lookup(symbols, referencingType, firstPart, secondPart)) == null) continue;
            return type;
        }
        return null;
    }

    TypeInfo getTypeFromThreePartRules(StandardSymbolResolver symbols, TypeInfo referencingType, TypeNameResolutionOrder order, String firstPart, String secondPart, String thirdPart) {
        for (ThreePartTypeNameResolveRule rule : order.getThreePartRules()) {
            TypeInfo type;
            if (referencingType.getCodeUnitDetails().getVersion().isGreaterThan(rule.getMaxVersion()) || (type = rule.lookup(symbols, referencingType, firstPart, secondPart, thirdPart)) == null) continue;
            return type;
        }
        return null;
    }

    TypeInfo getTypeFromFourPartRules(StandardSymbolResolver symbols, TypeInfo referencingType, TypeNameResolutionOrder order, String firstPart, String secondPart, String thirdPart, String fourthPart) {
        for (FourPartTypeNameResolveRule rule : order.getFourPartRules()) {
            TypeInfo type;
            if (referencingType.getCodeUnitDetails().getVersion().isGreaterThan(rule.getMaxVersion()) || (type = rule.lookup(symbols, referencingType, firstPart, secondPart, thirdPart, fourthPart)) == null) continue;
            return type;
        }
        return null;
    }
}

