/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.security;

import com.google.common.base.Objects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.apex.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlDeleteStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlInsertStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlMergeStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlUpdateStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlUpsertStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTField;
import net.sourceforge.pmd.lang.apex.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ASTFieldDeclarationStatements;
import net.sourceforge.pmd.lang.apex.ast.ASTIfElseBlockStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTMethodCallExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTNewKeyValueObjectExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTProperty;
import net.sourceforge.pmd.lang.apex.ast.ASTReferenceExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTSoqlExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableExpression;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.apex.rule.internal.Helper;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.properties.MultiValuePropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class ApexCRUDViolationRule
extends AbstractApexRule {
    private static final Pattern SELECT_FROM_PATTERN = Pattern.compile("[\\S|\\s]+?FROM[\\s]+?(\\w+)", 2);
    private static final String IS_CREATEABLE = "isCreateable";
    private static final String IS_DELETABLE = "isDeletable";
    private static final String IS_UPDATEABLE = "isUpdateable";
    private static final String IS_MERGEABLE = "isMergeable";
    private static final String IS_ACCESSIBLE = "isAccessible";
    private static final String ANY = "ANY";
    private static final String S_OBJECT_TYPE = "sObjectType";
    private static final String GET_DESCRIBE = "getDescribe";
    private static final String[] ESAPI_ISAUTHORIZED_TO_VIEW = new String[]{"ESAPI", "accessController", "isAuthorizedToView"};
    private static final String[] ESAPI_ISAUTHORIZED_TO_CREATE = new String[]{"ESAPI", "accessController", "isAuthorizedToCreate"};
    private static final String[] ESAPI_ISAUTHORIZED_TO_UPDATE = new String[]{"ESAPI", "accessController", "isAuthorizedToUpdate"};
    private static final String[] ESAPI_ISAUTHORIZED_TO_DELETE = new String[]{"ESAPI", "accessController", "isAuthorizedToDelete"};
    private static final String[] RESERVED_KEYS_FLS = new String[]{"Schema", "sObjectType"};
    private static final Pattern WITH_SECURITY_ENFORCED = Pattern.compile("(?is).*[^']\\s*WITH\\s+SECURITY_ENFORCED\\s*[^']*");
    private final Map<String, String> varToTypeMapping = new HashMap<String, String>();
    private final ListMultimap<String, String> typeToDMLOperationMapping = ArrayListMultimap.create();
    private final Map<String, String> checkedTypeToDMLOperationViaESAPI = new HashMap<String, String>();
    private final Map<String, ASTMethod> classMethods = new WeakHashMap<String, ASTMethod>();
    private String className;

    public ApexCRUDViolationRule() {
        this.setProperty((MultiValuePropertyDescriptor)CODECLIMATE_CATEGORIES, new String[]{"Security"});
        this.setProperty((PropertyDescriptor)CODECLIMATE_REMEDIATION_MULTIPLIER, 100);
        this.setProperty((PropertyDescriptor)CODECLIMATE_BLOCK_HIGHLIGHTING, false);
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        if (Helper.isTestMethodOrClass(node) || Helper.isSystemLevelClass(node)) {
            return data;
        }
        this.className = node.getImage();
        for (ASTMethod n : node.findDescendantsOfType(ASTMethod.class)) {
            StringBuilder sb = new StringBuilder().append(n.getDefiningType()).append(":").append(n.getCanonicalName()).append(":").append(n.getArity());
            this.classMethods.put(sb.toString(), n);
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTMethodCallExpression node, Object data) {
        this.collectCRUDMethodLevelChecks(node);
        return data;
    }

    @Override
    public Object visit(ASTDmlInsertStatement node, Object data) {
        this.checkForCRUD(node, data, IS_CREATEABLE);
        return data;
    }

    @Override
    public Object visit(ASTDmlDeleteStatement node, Object data) {
        this.checkForCRUD(node, data, IS_DELETABLE);
        return data;
    }

    @Override
    public Object visit(ASTDmlUpdateStatement node, Object data) {
        this.checkForCRUD(node, data, IS_UPDATEABLE);
        return data;
    }

    @Override
    public Object visit(ASTDmlUpsertStatement node, Object data) {
        this.checkForCRUD(node, data, IS_CREATEABLE);
        this.checkForCRUD(node, data, IS_UPDATEABLE);
        return data;
    }

    @Override
    public Object visit(ASTDmlMergeStatement node, Object data) {
        this.checkForCRUD(node, data, IS_MERGEABLE);
        return data;
    }

    @Override
    public Object visit(ASTAssignmentExpression node, Object data) {
        ASTSoqlExpression soql = (ASTSoqlExpression)node.getFirstChildOfType(ASTSoqlExpression.class);
        if (soql != null) {
            this.checkForAccessibility(soql, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTVariableDeclaration node, Object data) {
        String type = node.getType();
        this.addVariableToMapping(Helper.getFQVariableName(node), type);
        ASTSoqlExpression soql = (ASTSoqlExpression)node.getFirstChildOfType(ASTSoqlExpression.class);
        if (soql != null) {
            this.checkForAccessibility(soql, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        ASTSoqlExpression soql;
        ASTFieldDeclarationStatements field = (ASTFieldDeclarationStatements)node.getFirstParentOfType(ASTFieldDeclarationStatements.class);
        if (field != null) {
            String namesString = field.getTypeName();
            switch (namesString.toLowerCase(Locale.ROOT)) {
                case "list": 
                case "map": {
                    for (String typeArg : field.getTypeArguments()) {
                        this.varToTypeMapping.put(Helper.getFQVariableName(node), typeArg);
                    }
                    break;
                }
                default: {
                    this.varToTypeMapping.put(Helper.getFQVariableName(node), this.getSimpleType(namesString));
                }
            }
        }
        if ((soql = (ASTSoqlExpression)node.getFirstChildOfType(ASTSoqlExpression.class)) != null) {
            this.checkForAccessibility(soql, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTReturnStatement node, Object data) {
        ASTSoqlExpression soql = (ASTSoqlExpression)node.getFirstChildOfType(ASTSoqlExpression.class);
        if (soql != null) {
            this.checkForAccessibility(soql, data);
        }
        return data;
    }

    private void addVariableToMapping(String variableName, String type) {
        switch (type.toLowerCase(Locale.ROOT)) {
            case "list": 
            case "map": {
                break;
            }
            default: {
                this.varToTypeMapping.put(variableName, this.getSimpleType(type));
            }
        }
    }

    private String getSimpleType(String type) {
        String typeToUse = type;
        Pattern pattern = Pattern.compile("^[list<]?list<(\\S+?)>[>]?$", 2);
        Matcher matcher = pattern.matcher(typeToUse);
        if (matcher.find()) {
            typeToUse = matcher.group(1);
        }
        return typeToUse;
    }

    @Override
    public Object visit(ASTProperty node, Object data) {
        ASTField field = (ASTField)node.getFirstChildOfType(ASTField.class);
        if (field != null) {
            String fieldType = field.getType();
            this.addVariableToMapping(Helper.getFQVariableName(field), fieldType);
        }
        return data;
    }

    private void collectCRUDMethodLevelChecks(ASTMethodCallExpression node) {
        String method = node.getMethodName();
        ASTReferenceExpression ref = (ASTReferenceExpression)node.getFirstChildOfType(ASTReferenceExpression.class);
        if (ref == null) {
            return;
        }
        List<String> a = ref.getNames();
        if (!a.isEmpty()) {
            this.extractObjectAndFields(a, method, node.getDefiningType());
        } else {
            String resolvedType;
            ASTMethodCallExpression nestedMethodCall;
            if (Helper.isMethodCallChain(node, ESAPI_ISAUTHORIZED_TO_VIEW)) {
                this.extractObjectTypeFromESAPI(node, IS_ACCESSIBLE);
            }
            if (Helper.isMethodCallChain(node, ESAPI_ISAUTHORIZED_TO_CREATE)) {
                this.extractObjectTypeFromESAPI(node, IS_CREATEABLE);
            }
            if (Helper.isMethodCallChain(node, ESAPI_ISAUTHORIZED_TO_UPDATE)) {
                this.extractObjectTypeFromESAPI(node, IS_UPDATEABLE);
            }
            if (Helper.isMethodCallChain(node, ESAPI_ISAUTHORIZED_TO_DELETE)) {
                this.extractObjectTypeFromESAPI(node, IS_DELETABLE);
            }
            if ((nestedMethodCall = (ASTMethodCallExpression)ref.getFirstChildOfType(ASTMethodCallExpression.class)) != null && this.isLastMethodName(nestedMethodCall, S_OBJECT_TYPE, GET_DESCRIBE) && !this.typeToDMLOperationMapping.get((Object)(resolvedType = this.getType(nestedMethodCall))).contains(method)) {
                this.typeToDMLOperationMapping.put((Object)resolvedType, (Object)method);
            }
        }
    }

    private boolean isLastMethodName(ASTMethodCallExpression methodNode, String className, String methodName) {
        ASTReferenceExpression reference = (ASTReferenceExpression)methodNode.getFirstChildOfType(ASTReferenceExpression.class);
        return reference != null && reference.getNames().size() > 0 && reference.getNames().get(reference.getNames().size() - 1).equalsIgnoreCase(className) && Helper.isMethodName(methodNode, methodName);
    }

    private boolean isWithSecurityEnforced(ApexNode<?> node) {
        if (node instanceof ASTSoqlExpression) {
            return WITH_SECURITY_ENFORCED.matcher(((ASTSoqlExpression)node).getQuery()).matches();
        }
        return false;
    }

    private String getType(ASTMethodCallExpression methodNode) {
        ASTReferenceExpression reference = (ASTReferenceExpression)methodNode.getFirstChildOfType(ASTReferenceExpression.class);
        if (reference.getNames().size() > 0) {
            return reference.getDefiningType() + ":" + reference.getNames().get(0);
        }
        return "";
    }

    private void extractObjectAndFields(List<String> listIdentifiers, String method, String definingType) {
        int flsIndex = Collections.lastIndexOfSubList(listIdentifiers, Arrays.asList(RESERVED_KEYS_FLS));
        if (flsIndex != -1) {
            String objectTypeName = listIdentifiers.get(flsIndex + RESERVED_KEYS_FLS.length);
            if (!this.typeToDMLOperationMapping.get((Object)(definingType + ":" + objectTypeName)).contains(method)) {
                this.typeToDMLOperationMapping.put((Object)(definingType + ":" + objectTypeName), (Object)method);
            }
        }
    }

    private void checkForCRUD(ApexNode<?> node, Object data, String crudMethod) {
        String type;
        ASTVariableExpression variable;
        Set<ASTMethodCallExpression> prevCalls = this.getPreviousMethodCalls(node);
        for (ASTMethodCallExpression prevCall : prevCalls) {
            this.collectCRUDMethodLevelChecks(prevCall);
        }
        ASTMethod wrappingMethod = (ASTMethod)node.getFirstParentOfType(ASTMethod.class);
        ASTUserClass wrappingClass = (ASTUserClass)node.getFirstParentOfType(ASTUserClass.class);
        if (wrappingClass != null && Helper.isTestMethodOrClass(wrappingClass) || wrappingMethod != null && Helper.isTestMethodOrClass(wrappingMethod)) {
            return;
        }
        ASTNewKeyValueObjectExpression newObj = (ASTNewKeyValueObjectExpression)node.getFirstChildOfType(ASTNewKeyValueObjectExpression.class);
        if (newObj != null) {
            String type2 = Helper.getFQVariableName(newObj);
            this.validateCRUDCheckPresent(node, data, crudMethod, type2);
        }
        if ((variable = (ASTVariableExpression)node.getFirstChildOfType(ASTVariableExpression.class)) != null && (type = this.varToTypeMapping.get(Helper.getFQVariableName(variable))) != null) {
            StringBuilder typeCheck = new StringBuilder().append(node.getDefiningType()).append(":").append(type);
            this.validateCRUDCheckPresent(node, data, crudMethod, typeCheck.toString());
        }
    }

    private Set<ASTMethodCallExpression> getPreviousMethodCalls(ApexNode<?> self) {
        HashSet<ASTMethodCallExpression> innerMethodCalls = new HashSet<ASTMethodCallExpression>();
        ASTMethod outerMethod = (ASTMethod)self.getFirstParentOfType(ASTMethod.class);
        if (outerMethod != null) {
            ASTBlockStatement blockStatement = (ASTBlockStatement)outerMethod.getFirstChildOfType(ASTBlockStatement.class);
            this.recursivelyEvaluateCRUDMethodCalls(self, innerMethodCalls, blockStatement);
            List<ASTMethod> constructorMethods = this.findConstructorlMethods();
            for (ASTMethod method : constructorMethods) {
                innerMethodCalls.addAll(method.findDescendantsOfType(ASTMethodCallExpression.class));
            }
            this.mapCallToMethodDecl(self, innerMethodCalls, new ArrayList<ASTMethodCallExpression>(innerMethodCalls));
        }
        return innerMethodCalls;
    }

    private void recursivelyEvaluateCRUDMethodCalls(ApexNode<?> self, Set<ASTMethodCallExpression> innerMethodCalls, ASTBlockStatement blockStatement) {
        if (blockStatement != null) {
            int numberOfStatements = blockStatement.getNumChildren();
            for (int i = 0; i < numberOfStatements; ++i) {
                ApexNode match;
                Node n = blockStatement.getChild(i);
                if (n instanceof ASTIfElseBlockStatement) {
                    List innerBlocks = n.findDescendantsOfType(ASTBlockStatement.class);
                    for (ASTBlockStatement innerBlock : innerBlocks) {
                        this.recursivelyEvaluateCRUDMethodCalls(self, innerMethodCalls, innerBlock);
                    }
                }
                if (Objects.equal((Object)(match = (ApexNode)n.getFirstDescendantOfType(self.getClass())), self)) break;
                ASTMethodCallExpression methodCall = (ASTMethodCallExpression)n.getFirstDescendantOfType(ASTMethodCallExpression.class);
                if (methodCall == null) continue;
                this.mapCallToMethodDecl(self, innerMethodCalls, Arrays.asList(methodCall));
            }
        }
    }

    private void mapCallToMethodDecl(ApexNode<?> self, Set<ASTMethodCallExpression> innerMethodCalls, List<ASTMethodCallExpression> nodes) {
        for (ASTMethodCallExpression node : nodes) {
            if (Objects.equal((Object)node, self)) break;
            ASTMethod methodBody = this.resolveMethodCalls(node);
            if (methodBody == null) continue;
            innerMethodCalls.addAll(methodBody.findDescendantsOfType(ASTMethodCallExpression.class));
        }
    }

    private List<ASTMethod> findConstructorlMethods() {
        ArrayList<ASTMethod> ret = new ArrayList<ASTMethod>();
        Set constructors = this.classMethods.keySet().stream().filter(p -> p.contains("<init>") || p.contains("<clinit>") || p.startsWith(this.className + ":" + this.className + ":")).collect(Collectors.toSet());
        for (String c : constructors) {
            ret.add(this.classMethods.get(c));
        }
        return ret;
    }

    private ASTMethod resolveMethodCalls(ASTMethodCallExpression node) {
        StringBuilder sb = new StringBuilder().append(node.getDefiningType()).append(":").append(node.getMethodName()).append(":").append(node.getInputParametersSize());
        return this.classMethods.get(sb.toString());
    }

    private boolean isProperESAPICheckForDML(String typeToCheck, String dmlOperation) {
        boolean hasMapping = this.checkedTypeToDMLOperationViaESAPI.containsKey(typeToCheck.toString());
        if (hasMapping) {
            if (ANY.equals(dmlOperation)) {
                return true;
            }
            String dmlChecked = this.checkedTypeToDMLOperationViaESAPI.get(typeToCheck);
            return dmlChecked.equals(dmlOperation);
        }
        return false;
    }

    private void extractObjectTypeFromESAPI(ASTMethodCallExpression node, String dmlOperation) {
        List<String> identifiers;
        ASTReferenceExpression reference;
        ASTVariableExpression var = (ASTVariableExpression)node.getFirstChildOfType(ASTVariableExpression.class);
        if (var != null && (reference = (ASTReferenceExpression)var.getFirstChildOfType(ASTReferenceExpression.class)) != null && (identifiers = reference.getNames()).size() == 1) {
            StringBuilder sb = new StringBuilder().append(node.getDefiningType()).append(":").append(identifiers.get(0));
            this.checkedTypeToDMLOperationViaESAPI.put(sb.toString(), dmlOperation);
        }
    }

    private void validateCRUDCheckPresent(ApexNode<?> node, Object data, String crudMethod, String typeCheck) {
        boolean noSecurityEnforced;
        boolean missingKey = !this.typeToDMLOperationMapping.containsKey((Object)typeCheck);
        boolean isImproperDMLCheck = !this.isProperESAPICheckForDML(typeCheck, crudMethod);
        boolean bl = noSecurityEnforced = !this.isWithSecurityEnforced(node);
        if (missingKey) {
            if (isImproperDMLCheck && noSecurityEnforced) {
                this.addViolation(data, node);
            }
        } else {
            boolean properChecksHappened = false;
            List dmlOperationsChecked = this.typeToDMLOperationMapping.get((Object)typeCheck);
            for (String dmlOp : dmlOperationsChecked) {
                if (dmlOp.equalsIgnoreCase(crudMethod)) {
                    properChecksHappened = true;
                    break;
                }
                if (!ANY.equals(crudMethod)) continue;
                properChecksHappened = true;
                break;
            }
            if (!properChecksHappened) {
                this.addViolation(data, node);
            }
        }
    }

    private void checkForAccessibility(ASTSoqlExpression node, Object data) {
        ASTReturnStatement returnStatement;
        String variableWithClass;
        ASTVariableExpression variable;
        ASTAssignmentExpression assignment;
        ASTVariableDeclaration variableDecl;
        Set<String> typesFromSOQL = this.getTypesFromSOQLQuery(node);
        Set<ASTMethodCallExpression> prevCalls = this.getPreviousMethodCalls(node);
        for (ASTMethodCallExpression prevCall : prevCalls) {
            this.collectCRUDMethodLevelChecks(prevCall);
        }
        String returnType = null;
        ASTMethod wrappingMethod = (ASTMethod)node.getFirstParentOfType(ASTMethod.class);
        ASTUserClass wrappingClass = (ASTUserClass)node.getFirstParentOfType(ASTUserClass.class);
        if (wrappingClass != null && Helper.isTestMethodOrClass(wrappingClass) || wrappingMethod != null && Helper.isTestMethodOrClass(wrappingMethod)) {
            return;
        }
        if (wrappingMethod != null) {
            returnType = this.getReturnType(wrappingMethod);
        }
        if ((variableDecl = (ASTVariableDeclaration)node.getFirstParentOfType(ASTVariableDeclaration.class)) != null) {
            String type = variableDecl.getType();
            type = this.getSimpleType(type);
            StringBuilder typeCheck = new StringBuilder().append(variableDecl.getDefiningType()).append(":").append(type);
            if (typesFromSOQL.isEmpty()) {
                this.validateCRUDCheckPresent(node, data, ANY, typeCheck.toString());
            } else {
                for (String typeFromSOQL : typesFromSOQL) {
                    this.validateCRUDCheckPresent(node, data, ANY, typeFromSOQL);
                }
            }
        }
        if ((assignment = (ASTAssignmentExpression)node.getFirstParentOfType(ASTAssignmentExpression.class)) != null && (variable = (ASTVariableExpression)assignment.getFirstChildOfType(ASTVariableExpression.class)) != null && this.varToTypeMapping.containsKey(variableWithClass = Helper.getFQVariableName(variable))) {
            String type = this.varToTypeMapping.get(variableWithClass);
            if (typesFromSOQL.isEmpty()) {
                this.validateCRUDCheckPresent(node, data, ANY, type);
            } else {
                for (String typeFromSOQL : typesFromSOQL) {
                    this.validateCRUDCheckPresent(node, data, ANY, typeFromSOQL);
                }
            }
        }
        if ((returnStatement = (ASTReturnStatement)node.getFirstParentOfType(ASTReturnStatement.class)) != null) {
            if (typesFromSOQL.isEmpty()) {
                this.validateCRUDCheckPresent(node, data, ANY, returnType);
            } else {
                for (String typeFromSOQL : typesFromSOQL) {
                    this.validateCRUDCheckPresent(node, data, ANY, typeFromSOQL);
                }
            }
        }
    }

    private Set<String> getTypesFromSOQLQuery(ASTSoqlExpression node) {
        HashSet<String> retVal = new HashSet<String>();
        String canonQuery = node.getCanonicalQuery();
        Matcher m = SELECT_FROM_PATTERN.matcher(canonQuery);
        while (m.find()) {
            retVal.add(new StringBuffer().append(node.getDefiningType()).append(":").append(m.group(1)).toString());
        }
        return retVal;
    }

    private String getReturnType(ASTMethod method) {
        return method.getDefiningType() + ":" + method.getReturnType();
    }
}

