/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.modelica.rule;

import net.sourceforge.pmd.lang.modelica.ast.ASTComponentReference;
import net.sourceforge.pmd.lang.modelica.ast.ASTConnectClause;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaClassSpecialization;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaClassType;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaComponentDeclaration;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaType;
import net.sourceforge.pmd.lang.modelica.resolver.ResolutionResult;
import net.sourceforge.pmd.lang.modelica.resolver.ResolvableEntity;
import net.sourceforge.pmd.lang.modelica.rule.AbstractModelicaRule;

public class ConnectUsingNonConnector
extends AbstractModelicaRule {
    private void reportIfViolated(ASTComponentReference ref, Object data) {
        ResolutionResult<ResolvableEntity> resolution = ref.getResolutionCandidates();
        if (!resolution.isUnresolved()) {
            ResolvableEntity firstDecl = resolution.getBestCandidates().get(0);
            if (firstDecl instanceof ModelicaComponentDeclaration) {
                ModelicaComponentDeclaration componentDecl = (ModelicaComponentDeclaration)firstDecl;
                ResolutionResult<ModelicaType> componentTypes = componentDecl.getTypeCandidates();
                if (!componentTypes.isUnresolved()) {
                    if (componentTypes.getBestCandidates().get(0) instanceof ModelicaClassType) {
                        ModelicaClassType classDecl = (ModelicaClassType)componentTypes.getBestCandidates().get(0);
                        ModelicaClassSpecialization restriction = classDecl.getSpecialization();
                        if (!classDecl.isConnectorLike()) {
                            this.addViolation(data, ref, restriction.toString());
                        }
                    } else {
                        this.addViolation(data, ref, firstDecl.getDescriptiveName());
                    }
                }
            } else {
                this.addViolation(data, ref, firstDecl.getDescriptiveName());
            }
        }
    }

    @Override
    public Object visit(ASTConnectClause node, Object data) {
        ASTComponentReference lhs = (ASTComponentReference)node.getChild(0);
        ASTComponentReference rhs = (ASTComponentReference)node.getChild(1);
        this.reportIfViolated(lhs, data);
        this.reportIfViolated(rhs, data);
        return super.visit(node, data);
    }
}

