/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedAction;
import net.sourceforge.pmd.annotation.InternalApi;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

@Deprecated
@InternalApi
public final class IOUtil {
    private IOUtil() {
    }

    public static Writer createWriter() {
        return new OutputStreamWriter(System.out);
    }

    private static Charset getDefaultCharset() {
        String csn = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("file.encoding");
            }
        });
        try {
            return Charset.forName(csn);
        }
        catch (UnsupportedCharsetException e) {
            return StandardCharsets.UTF_8;
        }
    }

    public static Writer createWriter(String reportFile) {
        try {
            if (StringUtils.isBlank((CharSequence)reportFile)) {
                return IOUtil.createWriter();
            }
            Path path = new File(reportFile).toPath();
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            return Files.newBufferedWriter(path, IOUtil.getDefaultCharset(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Reader skipBOM(Reader source) {
        BufferedReader in = new BufferedReader(source);
        try {
            ((Reader)in).mark(1);
            int firstCharacter = ((Reader)in).read();
            if (firstCharacter != 65279) {
                ((Reader)in).reset();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error while trying to skip BOM marker", e);
        }
        return in;
    }

    public static void tryCloseClassLoader(ClassLoader classLoader) {
        if (classLoader instanceof Closeable) {
            IOUtils.closeQuietly((Closeable)((Closeable)((Object)classLoader)));
        }
    }
}

