/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor.reference;

import apex.common.base.ObjectHash;
import apex.jorje.data.Locatable;
import apex.jorje.data.Location;
import apex.jorje.semantic.ast.visitor.reference.ReferenceInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public class ExternalDependency
implements Locatable {
    private final TypeInfo type;
    private final Location loc;
    private final ReferenceInfo referenceInfo;

    private ExternalDependency(TypeInfo type, Location loc, ReferenceInfo referenceInfo) {
        this.type = type;
        this.loc = loc;
        this.referenceInfo = referenceInfo;
    }

    public static ExternalDependency create(TypeInfo type, Location loc, ReferenceInfo referenceInfo) {
        return new ExternalDependency(type, loc, referenceInfo);
    }

    public TypeInfo getTypeInfo() {
        return this.type;
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    public ReferenceInfo getReferenceInfo() {
        return this.referenceInfo;
    }

    public int hashCode() {
        return ObjectHash.hash(this.type, this.loc, this.referenceInfo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalDependency that = (ExternalDependency)o;
        return TypeInfoEquivalence.isEquivalent(this.type, that.type) && Objects.equals(this.loc, that.loc) && Objects.equals(this.referenceInfo, that.referenceInfo);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("type", this.type).add("loc", this.loc).add("referenceInfo", this.referenceInfo).toString();
    }
}

