/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.compiler;

import apex.jorje.data.ast.TriggerUsage;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.base.MoreObjects;
import com.google.common.collect.MoreMaps;
import java.util.BitSet;
import java.util.Map;
import java.util.Set;

public class CompilationOutput {
    private final TypeInfo type;
    private final ExtendedTriggerInfo triggerInfo;
    private final byte[] bytes;
    private final Map<String, CompilationOutput> innerOutputs;
    private final BitSet lines;

    private CompilationOutput(Builder builder) {
        this.type = builder.type;
        this.triggerInfo = builder.triggerInfo;
        this.bytes = builder.bytes;
        this.innerOutputs = MoreMaps.toEmptyMap(builder.innerOutputs);
        this.lines = builder.lines;
    }

    public static Builder builder(TypeInfo type) {
        return new Builder(type);
    }

    public TypeInfo getType() {
        return this.type;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @SfdcCalled
    public ExtendedTriggerInfo getTriggerInfo() {
        return this.triggerInfo;
    }

    @SfdcCalled
    public BitSet getLines() {
        return this.lines;
    }

    public Map<String, CompilationOutput> getInnerOutputs() {
        return this.innerOutputs;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("type", this.type).add("innerOutputs", this.innerOutputs).toString();
    }

    public static class Builder {
        private final TypeInfo type;
        private final Map<String, CompilationOutput> innerOutputs;
        private ExtendedTriggerInfo triggerInfo;
        private byte[] bytes;
        private BitSet lines;

        private Builder(TypeInfo type) {
            this.type = type;
            this.innerOutputs = MoreMaps.newCaseInsensitiveMap();
        }

        public CompilationOutput build() {
            return new CompilationOutput(this);
        }

        public Builder addInnerType(Compilation innerType) {
            this.innerOutputs.put(innerType.getOutput().getType().getBytecodeName(), innerType.getOutput());
            assert (innerType.getOutput().getInnerOutputs().isEmpty()) : "inner type cannot have inner types";
            return this;
        }

        public Builder setTriggerInfo(SObjectTypeInfo entityTypeInfo, Set<TriggerUsage> usages) {
            this.triggerInfo = new ExtendedTriggerInfo(entityTypeInfo, usages);
            return this;
        }

        public Builder setBytes(byte[] bytes) {
            this.bytes = bytes;
            return this;
        }

        public Builder setLines(BitSet lines) {
            this.lines = lines;
            return this;
        }
    }

    public static class ExtendedTriggerInfo {
        private final SObjectTypeInfo entityTypeInfo;
        private final Set<TriggerUsage> usages;

        private ExtendedTriggerInfo(SObjectTypeInfo entityTypeInfo, Set<TriggerUsage> usages) {
            this.entityTypeInfo = entityTypeInfo;
            this.usages = usages;
        }

        @SfdcCalled
        public SObjectTypeInfo getEntityTypeInfo() {
            return this.entityTypeInfo;
        }

        @SfdcCalled
        public Set<TriggerUsage> getUsages() {
            return this.usages;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("target", this.entityTypeInfo).add("usages", this.usages).toString();
        }
    }
}

