/* PgSqlClient - ADO.NET Data Provider for PostgreSQL 7.4+
 * Copyright (c) 2003-2004 Carlos Guzman Alvarez
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Text;

namespace PostgreSql.Data.NPgClient
{
	internal class PgConnectionParams
	{
		#region Fields

		private string		serverName;		
		private string		database;
		private string		userName;
		private string		userPassword;
		private int			serverPort;
		private int			packetSize;		
		private int			timeout;
		private bool		pooling;
		private Encoding	encoding;
		private	bool		ssl;
		private bool		simpleQueryMode;

		#endregion

		#region Properties

		public string ServerName
		{
			get { return serverName; }
			set { serverName = value; }
		}

		public string Database
		{
			get { return database; }
			set { database = value; }
		}

		public string UserName
		{
			get { return userName; }
			set { userName = value; }
		}

		public string UserPassword
		{
			get { return userPassword; }
			set { userPassword = value; }
		}

		public int PacketSize
		{
			get { return packetSize; }
			set { packetSize = value; }
		}

		public int ServerPort
		{
			get { return serverPort; }
			set { serverPort = value; }
		}

		public Encoding Encoding
		{
			get { return encoding; }
			set { encoding = value; }
		}

		public int Timeout
		{
			get { return timeout; }
			set { timeout = value; }
		}

		public bool Pooling
		{
			get { return pooling; }
			set { pooling = value; }
		}

		public bool SSL
		{
			get { return ssl; }
			set { ssl = value; }
		}

		public bool SimpleQueryMode
		{
			get { return simpleQueryMode; }
			set { simpleQueryMode = value; }
		}

		#endregion

		#region Constructors

		public PgConnectionParams()
		{
			serverName		= "localhost";			
			userName		= "postgres";
			userPassword	= "postgres";
			serverPort		= 5432;
			packetSize		= 8192;
			pooling			= true;
			timeout			= 15;
			encoding		= Encoding.Default;
			simpleQueryMode	= false;
		}

		#endregion
	}
}