/* PgSqlClient - ADO.NET Data Provider for PostgreSQL 7.4+
 * Copyright (c) 2003-2004 Carlos Guzman Alvarez
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Text;

namespace PostgreSql.Data.NPgClient
{
	internal class PgCharSet
	{
		#region Fields

		private string		charSet;
		private Encoding	encoding;

		#endregion

		#region Properties

		public string CharSet
		{
			get { return charSet; }
		}

		public Encoding Encoding
		{
			get { return encoding; }
		}

		#endregion

		#region Constructors

		public PgCharSet()
		{
		}

		public PgCharSet(string charSet, string systemCharSet)
		{
			this.charSet	= charSet;			
			this.encoding	= Encoding.GetEncoding(systemCharSet);
		}

		public PgCharSet(string charSet, int cp)
		{
			this.charSet	= charSet;			
			this.encoding	= Encoding.GetEncoding(cp);
		}

		#endregion
	}
}
