///////////////////////////////////////////////////////////////////////////
// mathex 0.2 (beta) - Copyright (C) 2000-2003, by Sadao Massago         //
// file: userfunctest.cpp (user function test)                           //
// requires: mathex.h, mathex.cpp                                        //
// project web page: http://sourceforge.net/projects/sscilib/            //
// ----------------------------------------------------------------------//
// The mathex library and related files is licenced under the term of    //
// GNU LGPL (Lesser General Public License) version 2.1 or latter        //
// with exceptions that allow for static linking.                        //
// See license.txt for detail.                                           //
// For GNU LGPL, see lesser.txt.                                         //
// For information over GNU or GNU compatible license, visit the site    //
// http://www.gnu.org.                                                   //
///////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <iomanip>
#include <string>
#include <vector>

// #define _DEBUG_

#include "mathex.h"

   using namespace std;


/// norm function
    double norm(vector<double> const &x)
   {
      double sum =0;
      if(x.empty())
         throw smlib::mathex::error("norm(): empty argument\n");
      for(unsigned i=0; i<x.size(); i++)
         sum += x[i]*x[i];
      return sqrt(sum);
   } // norm

// fmod function
    double myfmod(vector<double> const &x)
   {
   // if(x.size()!= 2)
   //   throw smlib::mathex::error("fmod(): invalid number of argument\n");
      return fmod(x[0], x[1]);
   } // myfmod

    int main()
   {
      // for variable sharing/setting example
      double x, y;  // x, y are used to table example too
      string s;
      bool parsed;
      // for table example
      smlib::mathex expr;
     
      // sharing with internal variables ...
      // table making example
      cout << "function table example\n";
      // expr.delvar();
      // adding user function
      if(!expr.addfunc("norm", norm, smlib::mathex::UNDEFARGS) ||
         !expr.addfunc("fmod", myfmod, 2)) {
         cout << "Error adding function norm and fmod.\n";
         return 1;
      }
      // sharing with internal variables ... 
      if(!expr.addvar("x", &x) || !expr.addvar("y", &y)) {
         cout << "Error adding internal variable x and y as name \"x\" and \"y\"\n";
         return 1;
      }

      cout << "x = "; cin >> x;
      cout << "y = "; cin >> y;
      
      cout << "Enter expression of x and y: ";
      
      do { 
         s.erase();
         getline(cin, s); // getline delete '\n'character?
      } while(s.empty());
      
      try {
         parsed = false;
         expr.expression(s); // setting expression string
         expr.parse(); // parse
         parsed = true;
         #ifdef _DEBUG_
      	  expr.printbytecode();
      	#endif
         cout << "f("<<x<<","<<y<<") = ";
      	cout << expr.eval()<<endl;
      }
          catch(smlib::mathex::error e) { // mathex exception
            cout << e.what() << endl; // erroer message
            if(!parsed) {
            	  // show expression and error position
               cout << s << endl;
               cout << setw(expr.stopposition()) << "^" << endl;
            }
         }
          catch(exception e) { // unknow exception
            cout << e.what() << endl; // erroer message
         }
      
      return 0;
   } // main()

// end of tabletest.cpp
