/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.dao.id.EntityID;
import org.jetbrains.exposed.sql.AliasKt;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.CompositeColumn;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.Query;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.StatementType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0002J\u0015\u0010\u0018\u001a\u00020\n2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0096\u0002JL\u0010\u0019\u001a\u00020\u0016\"\u0004\b\u0001\u0010\u001a\"\u000e\b\u0002\u0010\u001b*\b\u0012\u0004\u0012\u0002H\u001a0\u001c\"\u000e\b\u0003\u0010\u001d*\b\u0012\u0004\u0012\u0002H\u001a0\u001e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u00112\u0006\u0010\u001f\u001a\u0002H\u001dH\u0087\u0002\u00a2\u0006\u0004\b \u0010!JR\u0010\u0019\u001a\u00020\u0016\"\u000e\b\u0001\u0010\u001a*\b\u0012\u0004\u0012\u0002H\u001a0\"\"\b\b\u0002\u0010\u001d*\u0002H\u001a\"\u0010\b\u0003\u0010\u001b*\n\u0012\u0004\u0012\u0002H\u001d\u0018\u00010\u001c2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u00112\u0006\u0010\u001f\u001a\u0002H\u001aH\u0087\u0002\u00a2\u0006\u0004\b#\u0010$J*\u0010\u0019\u001a\u00020\u0016\"\u0004\b\u0001\u0010\u001a2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u00112\u0006\u0010\u001f\u001a\u0002H\u001aH\u0096\u0002\u00a2\u0006\u0002\u0010%J%\u0010\u0019\u001a\u00020\u0016\"\u0004\b\u0001\u0010\u001a2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u00112\u0006\u0010\u001f\u001a\u00020&H\u0096\u0002JD\u0010\u0019\u001a\u00020\u0016\"\u0004\b\u0001\u0010\u0001\"\b\b\u0002\u0010\u001a*\u0002H\u0001\"\u000e\b\u0003\u0010\u001d*\b\u0012\u0004\u0012\u0002H\u001a0\u001e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00010\u00112\u0006\u0010\u001f\u001a\u0002H\u001dH\u0096\u0002\u00a2\u0006\u0002\u0010!J.\u0010\u0019\u001a\u00020\u0016\"\b\b\u0001\u0010\u001a*\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u001a0'2\u0006\u0010\u001f\u001a\u0002H\u001aH\u0096\u0002\u00a2\u0006\u0002\u0010(J6\u0010)\u001a\u00020\u0016\"\u0004\b\u0001\u0010\u0001\"\n\b\u0002\u0010\u001a*\u0004\u0018\u0001H\u00012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00010\u00112\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001eH\u0016JG\u0010)\u001a\u00020\u0016\"\u0004\b\u0001\u0010\u0001\"\n\b\u0002\u0010\u001a*\u0004\u0018\u0001H\u00012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00010\u00112\u001d\u0010\u001f\u001a\u0019\u0012\u0004\u0012\u00020+\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001a0\u001e0*\u00a2\u0006\u0002\b,H\u0016R\u001a\u0010\t\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR&\u0010\u000f\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006-"}, d2={"Lorg/jetbrains/exposed/sql/statements/UpdateBuilder;", "T", "Lorg/jetbrains/exposed/sql/statements/Statement;", "type", "Lorg/jetbrains/exposed/sql/statements/StatementType;", "targets", "", "Lorg/jetbrains/exposed/sql/Table;", "(Lorg/jetbrains/exposed/sql/statements/StatementType;Ljava/util/List;)V", "hasBatchedValues", "", "getHasBatchedValues", "()Z", "setHasBatchedValues", "(Z)V", "values", "", "Lorg/jetbrains/exposed/sql/Column;", "", "getValues", "()Ljava/util/Map;", "checkThatExpressionWasNotSetInPreviousBatch", "", "column", "contains", "set", "S", "ID", "Lorg/jetbrains/exposed/dao/id/EntityID;", "E", "Lorg/jetbrains/exposed/sql/Expression;", "value", "setWithEntityIdExpression", "(Lorg/jetbrains/exposed/sql/Column;Lorg/jetbrains/exposed/sql/Expression;)V", "", "setWithEntityIdValue", "(Lorg/jetbrains/exposed/sql/Column;Ljava/lang/Comparable;)V", "(Lorg/jetbrains/exposed/sql/Column;Ljava/lang/Object;)V", "Lorg/jetbrains/exposed/sql/Query;", "Lorg/jetbrains/exposed/sql/CompositeColumn;", "(Lorg/jetbrains/exposed/sql/CompositeColumn;Ljava/lang/Object;)V", "update", "Lkotlin/Function1;", "Lorg/jetbrains/exposed/sql/SqlExpressionBuilder;", "Lkotlin/ExtensionFunctionType;", "exposed-core"})
public abstract class UpdateBuilder<T>
extends Statement<T> {
    @NotNull
    private final Map<Column<?>, Object> values;
    private boolean hasBatchedValues;

    public UpdateBuilder(@NotNull StatementType type, @NotNull List<? extends Table> targets) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        super(type, targets);
        this.values = new LinkedHashMap();
    }

    @NotNull
    protected final Map<Column<?>, Object> getValues() {
        return this.values;
    }

    public boolean contains(@NotNull Column<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return this.values.containsKey(column);
    }

    protected final boolean getHasBatchedValues() {
        return this.hasBatchedValues;
    }

    protected final void setHasBatchedValues(boolean bl) {
        this.hasBatchedValues = bl;
    }

    private final void checkThatExpressionWasNotSetInPreviousBatch(Column<?> column) {
        if (!(!this.values.containsKey(column) || !this.hasBatchedValues)) {
            boolean bl = false;
            String string = column + " is already initialized in a batch";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public <S> void set(@NotNull Column<S> column, S value) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        if (!(column.getColumnType().getNullable() || value != null && !Intrinsics.areEqual(value, (Object)Op.NULL.INSTANCE))) {
            boolean bl = false;
            String string = Intrinsics.stringPlus((String)"Trying to set null to not nullable column ", column);
            throw new IllegalArgumentException(string.toString());
        }
        column.getColumnType().validateValueBeforeUpdate(value);
        this.values.put(column, value);
    }

    @JvmName(name="setWithEntityIdValue")
    public final <S extends Comparable<? super S>, E extends S, ID extends EntityID<E>> void setWithEntityIdValue(@NotNull Column<ID> column, @NotNull S value) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        column.getColumnType().validateValueBeforeUpdate(value);
        this.values.put(column, value);
    }

    @JvmName(name="setWithEntityIdExpression")
    public final <S, ID extends EntityID<S>, E extends Expression<S>> void setWithEntityIdExpression(@NotNull Column<ID> column, @NotNull E value) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (!(column.getColumnType().getNullable() || !Intrinsics.areEqual(value, (Object)Op.NULL.INSTANCE))) {
            boolean bl = false;
            String string = Intrinsics.stringPlus((String)"Trying to set null to not nullable column ", column);
            throw new IllegalArgumentException(string.toString());
        }
        this.checkThatExpressionWasNotSetInPreviousBatch(column);
        column.getColumnType().validateValueBeforeUpdate(value);
        this.values.put(column, value);
    }

    public <T, S extends T, E extends Expression<S>> void set(@NotNull Column<T> column, @NotNull E value) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.update(column, value);
    }

    public <S> void set(@NotNull Column<S> column, @NotNull Query value) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.update(column, AliasKt.wrapAsExpression(value));
    }

    public <S> void set(@NotNull CompositeColumn<S> column, @NotNull S value) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Map<Column<?>, Object> $this$forEach$iv = column.getRealColumnsWithValues(value);
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Column<?>, Object>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Column<?>, Object> element$iv;
            Map.Entry<Column<?>, Object> $dstr$realColumn$itsValue = element$iv = iterator2.next();
            boolean bl = false;
            Column<?> realColumn = $dstr$realColumn$itsValue.getKey();
            Object itsValue = $dstr$realColumn$itsValue.getValue();
            this.set(realColumn, (Expression)itsValue);
        }
    }

    public <T, S extends T> void update(@NotNull Column<T> column, @NotNull Expression<S> value) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.checkThatExpressionWasNotSetInPreviousBatch(column);
        column.getColumnType().validateValueBeforeUpdate(value);
        this.values.put(column, value);
    }

    public <T, S extends T> void update(@NotNull Column<T> column, @NotNull Function1<? super SqlExpressionBuilder, ? extends Expression<S>> value) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.update(column, (Expression)value.invoke((Object)SqlExpressionBuilder.INSTANCE));
    }
}

