/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.core.connections;

import java.util.List;
import org.grails.datastore.mapping.core.connections.ConnectionSource;
import org.grails.datastore.mapping.core.connections.ConnectionSourceFactory;
import org.grails.datastore.mapping.core.connections.ConnectionSourceSettings;
import org.grails.datastore.mapping.core.connections.ConnectionSourceSettingsBuilder;
import org.grails.datastore.mapping.engine.types.CustomTypeMarshaller;
import org.grails.datastore.mapping.multitenancy.TenantResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.PropertyResolver;

public abstract class AbstractConnectionSourceFactory<T, S extends ConnectionSourceSettings>
implements ConnectionSourceFactory<T, S> {
    private TenantResolver tenantResolver;
    private List<CustomTypeMarshaller> customTypes;

    @Autowired(required=false)
    public void setTenantResolver(TenantResolver tenantResolver) {
        this.tenantResolver = tenantResolver;
    }

    @Autowired(required=false)
    public void setCustomTypes(List<CustomTypeMarshaller> customTypes) {
        this.customTypes = customTypes;
    }

    @Override
    public ConnectionSource<T, S> create(String name, PropertyResolver configuration) {
        ConnectionSourceSettingsBuilder builder = new ConnectionSourceSettingsBuilder(configuration);
        ConnectionSourceSettings fallbackSettings = (ConnectionSourceSettings)builder.build();
        if (this.tenantResolver != null) {
            fallbackSettings.getMultiTenancy().setTenantResolver(this.tenantResolver);
        }
        if (this.customTypes != null) {
            fallbackSettings.getCustom().getTypes().addAll(this.customTypes);
        }
        return this.create(name, configuration, fallbackSettings);
    }

    @Override
    public ConnectionSource<T, S> create(String name, PropertyResolver configuration, ConnectionSource<T, S> fallbackConnectionSource) {
        return this.create(name, configuration, (ConnectionSourceSettings)fallbackConnectionSource.getSettings());
    }

    @Override
    public final <F extends ConnectionSourceSettings> ConnectionSource<T, S> create(String name, PropertyResolver configuration, F fallbackSettings) {
        boolean isDefaultDataSource = "DEFAULT".equals(name);
        S settings = this.buildSettings(name, configuration, fallbackSettings, isDefaultDataSource);
        return this.create(name, settings);
    }

    @Override
    public ConnectionSource<T, S> createRuntime(String name, PropertyResolver configuration, S fallbackSettings) {
        S settings = this.buildRuntimeSettings(name, configuration, (ConnectionSourceSettings)fallbackSettings);
        return this.create(name, settings);
    }

    public <F extends ConnectionSourceSettings> S buildRuntimeSettings(String name, PropertyResolver configuration, F fallbackSettings) {
        return this.buildSettings(name, configuration, fallbackSettings, false);
    }

    protected abstract <F extends ConnectionSourceSettings> S buildSettings(String var1, PropertyResolver var2, F var3, boolean var4);
}

