/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import io.micronaut.ast.groovy.utils.InMemoryByteCodeGroovyClassLoader;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import io.micronaut.inject.writer.DirectoryClassWriterOutputVisitor;
import io.micronaut.inject.writer.GeneratedFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import org.codehaus.groovy.control.CompilationUnit;

class GroovyClassWriterOutputVisitor
implements ClassWriterOutputVisitor {
    private final CompilationUnit compilationUnit;

    GroovyClassWriterOutputVisitor(CompilationUnit compilationUnit) {
        this.compilationUnit = compilationUnit;
    }

    public OutputStream visitClass(String classname, @Nullable Element originatingElement) throws IOException {
        return this.visitClass(classname, new Element[]{originatingElement});
    }

    public OutputStream visitClass(final String classname, Element ... originatingElements) throws IOException {
        File classesDir = this.compilationUnit.getConfiguration().getTargetDirectory();
        if (classesDir != null) {
            DirectoryClassWriterOutputVisitor outputVisitor = new DirectoryClassWriterOutputVisitor(classesDir);
            return outputVisitor.visitClass(classname, originatingElements);
        }
        if (this.compilationUnit.getClassLoader() instanceof InMemoryByteCodeGroovyClassLoader) {
            return new OutputStream(){

                @Override
                public void write(int b) {
                }

                @Override
                public void write(byte[] b) {
                    ((InMemoryByteCodeGroovyClassLoader)GroovyClassWriterOutputVisitor.this.compilationUnit.getClassLoader()).addClass(classname, b);
                }
            };
        }
        return new ByteArrayOutputStream();
    }

    public void visitServiceDescriptor(String type, String classname) {
        File classesDir = this.compilationUnit.getConfiguration().getTargetDirectory();
        if (classesDir != null) {
            DirectoryClassWriterOutputVisitor outputVisitor = new DirectoryClassWriterOutputVisitor(classesDir);
            outputVisitor.visitServiceDescriptor(type, classname);
            outputVisitor.finish();
        }
    }

    public void visitServiceDescriptor(String type, String classname, Element originatingElement) {
        File classesDir = this.compilationUnit.getConfiguration().getTargetDirectory();
        if (classesDir != null) {
            DirectoryClassWriterOutputVisitor outputVisitor = new DirectoryClassWriterOutputVisitor(classesDir);
            outputVisitor.visitServiceDescriptor(type, classname, originatingElement);
            outputVisitor.finish();
        }
    }

    public Optional<GeneratedFile> visitMetaInfFile(String path, Element ... originatingElements) {
        File classesDir = this.compilationUnit.getConfiguration().getTargetDirectory();
        if (classesDir != null) {
            DirectoryClassWriterOutputVisitor outputVisitor = new DirectoryClassWriterOutputVisitor(classesDir);
            return outputVisitor.visitMetaInfFile(path, originatingElements);
        }
        return Optional.empty();
    }

    public Optional<GeneratedFile> visitGeneratedFile(String path) {
        File classesDir = this.compilationUnit.getConfiguration().getTargetDirectory();
        if (classesDir != null) {
            DirectoryClassWriterOutputVisitor outputVisitor = new DirectoryClassWriterOutputVisitor(classesDir);
            return outputVisitor.visitGeneratedFile(path);
        }
        return Optional.empty();
    }

    public void finish() {
    }
}

