/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.codec;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.json.JsonFeatures;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Internal
public final class JacksonFeatures
implements JsonFeatures {
    private final Map<SerializationFeature, Boolean> serializationFeatures = new EnumMap<SerializationFeature, Boolean>(SerializationFeature.class);
    private final Map<DeserializationFeature, Boolean> deserializationFeatures = new EnumMap<DeserializationFeature, Boolean>(DeserializationFeature.class);
    private final List<Class<? extends Module>> additionalModules = new ArrayList<Class<? extends Module>>();

    public static JacksonFeatures fromAnnotation(AnnotationValue<io.micronaut.jackson.annotation.JacksonFeatures> jacksonFeaturesAnn) {
        Object[] additionalModules;
        DeserializationFeature[] disabledDeserializationFeatures;
        SerializationFeature[] disabledSerializationFeatures;
        DeserializationFeature[] enabledDeserializationFeatures;
        JacksonFeatures jacksonFeatures = new JacksonFeatures();
        SerializationFeature[] enabledSerializationFeatures = jacksonFeaturesAnn.get((CharSequence)"enabledSerializationFeatures", SerializationFeature[].class).orElse(null);
        if (enabledSerializationFeatures != null) {
            for (SerializationFeature serializationFeature : enabledSerializationFeatures) {
                jacksonFeatures.addFeature(serializationFeature, true);
            }
        }
        if ((enabledDeserializationFeatures = (DeserializationFeature[])jacksonFeaturesAnn.get((CharSequence)"enabledDeserializationFeatures", DeserializationFeature[].class).orElse(null)) != null) {
            for (DeserializationFeature deserializationFeature : enabledDeserializationFeatures) {
                jacksonFeatures.addFeature(deserializationFeature, true);
            }
        }
        if ((disabledSerializationFeatures = (SerializationFeature[])jacksonFeaturesAnn.get((CharSequence)"disabledSerializationFeatures", SerializationFeature[].class).orElse(null)) != null) {
            for (SerializationFeature serializationFeature : disabledSerializationFeatures) {
                jacksonFeatures.addFeature(serializationFeature, false);
            }
        }
        if ((disabledDeserializationFeatures = (DeserializationFeature[])jacksonFeaturesAnn.get((CharSequence)"disabledDeserializationFeatures", DeserializationFeature[].class).orElse(null)) != null) {
            for (DeserializationFeature feature : disabledDeserializationFeatures) {
                jacksonFeatures.addFeature(feature, false);
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])(additionalModules = jacksonFeaturesAnn.classValues("additionalModules")))) {
            for (Object additionalModule : additionalModules) {
                jacksonFeatures.addModule((Class<? extends Module>)additionalModule);
            }
        }
        return jacksonFeatures;
    }

    public JacksonFeatures addFeature(SerializationFeature serializationFeature, boolean isEnabled) {
        this.serializationFeatures.put(serializationFeature, isEnabled);
        return this;
    }

    public JacksonFeatures addFeature(DeserializationFeature deserializationFeature, boolean isEnabled) {
        this.deserializationFeatures.put(deserializationFeature, isEnabled);
        return this;
    }

    @NonNull
    public JacksonFeatures addModule(@NonNull Class<? extends Module> moduleClass) {
        Objects.requireNonNull(moduleClass, "moduleClass");
        this.additionalModules.add(moduleClass);
        return this;
    }

    public Map<SerializationFeature, Boolean> getSerializationFeatures() {
        return this.serializationFeatures;
    }

    public Map<DeserializationFeature, Boolean> getDeserializationFeatures() {
        return this.deserializationFeatures;
    }

    @NonNull
    public List<Class<? extends Module>> getAdditionalModules() {
        return this.additionalModules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JacksonFeatures that = (JacksonFeatures)o;
        return Objects.equals(this.serializationFeatures, that.serializationFeatures) && Objects.equals(this.deserializationFeatures, that.deserializationFeatures);
    }

    public int hashCode() {
        return Objects.hash(this.serializationFeatures, this.deserializationFeatures);
    }
}

