/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.core.grailsversion;

import groovy.lang.GroovyObject;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.transform.EqualsAndHashCode;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.util.HashCodeHelper;
import org.grails.datastore.mapping.core.grailsversion.Snapshot;
import org.grails.datastore.mapping.reflect.ClassUtils;

@EqualsAndHashCode(includes={"versionText"})
public class GrailsVersion
implements Comparable<GrailsVersion>,
GroovyObject {
    private static GrailsVersion currentVersion;
    private int major;
    private int minor;
    private int patch;
    private Snapshot snapshot;
    private String versionText;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public GrailsVersion(String version) {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Object[] parts = version.split("\\.");
        if (parts.length >= 3) {
            String string;
            this.versionText = string = version;
            Integer n = StringGroovyMethods.toInteger((CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])parts, (int)0), CharSequence.class)));
            this.major = n;
            Integer n2 = StringGroovyMethods.toInteger((CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])parts, (int)1), CharSequence.class)));
            this.minor = n2;
            if (parts.length > 3) {
                Snapshot snapshot;
                this.snapshot = snapshot = new Snapshot(ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])parts, (int)3)));
            } else if (((String)BytecodeInterface8.objectArrayGet((Object[])parts, (int)2)).contains("-")) {
                Snapshot snapshot;
                int n3;
                String[] subParts = ((String)BytecodeInterface8.objectArrayGet((Object[])parts, (int)2)).split("-");
                this.patch = n3 = DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.first((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)subParts, Object[].class))), Integer.TYPE));
                this.snapshot = snapshot = new Snapshot(DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.getAt((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)subParts, Object[].class)), (IntRange)new IntRange(true, 1, Integer.valueOf(-1).intValue())), (String)"-"));
            } else {
                Integer n4 = StringGroovyMethods.toInteger((CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])parts, (int)2), CharSequence.class)));
                this.patch = n4;
            }
        } else {
            throw (Throwable)new IllegalArgumentException("GrailsVersion only supports comparison of versions with 3 or 4 parts");
        }
    }

    public String toString() {
        return this.versionText;
    }

    public static boolean isAtLeastMajorMinor(int majorVersion, int minorVersion) {
        GrailsVersion current = GrailsVersion.getCurrent();
        return GrailsVersion.isAtLeastMajorMinorImpl(current, majorVersion, minorVersion);
    }

    public static boolean isAtLeastMajorMinor(String version, int majorVersion, int minorVersion) {
        return GrailsVersion.isAtLeastMajorMinorImpl(new GrailsVersion(version), majorVersion, minorVersion);
    }

    private static boolean isAtLeastMajorMinorImpl(GrailsVersion version, int majorVersion, int minorVersion) {
        if (version != null) {
            if (version.getMajor() > majorVersion) {
                return true;
            }
            return version.getMajor() == majorVersion && version.getMinor() >= minorVersion;
        }
        return false;
    }

    public static boolean isAtLeast(String requiredVersion) {
        GrailsVersion currentVersion = GrailsVersion.getCurrent();
        return GrailsVersion.isAtLeastImpl(currentVersion, requiredVersion);
    }

    public static boolean isAtLeast(String version, String requiredVersion) {
        return GrailsVersion.isAtLeastImpl(new GrailsVersion(version), requiredVersion);
    }

    private static boolean isAtLeastImpl(GrailsVersion version, String requiredVersion) {
        if (version != null) {
            GrailsVersion otherVersion = new GrailsVersion(requiredVersion);
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)version, (Object)otherVersion) || ScriptBytecodeAdapter.compareEqual((Object)version, (Object)otherVersion)) {
                return true;
            }
        }
        return false;
    }

    public static GrailsVersion getCurrent() {
        if (currentVersion != null) {
            return currentVersion;
        }
        if (ClassUtils.isPresent("grails.util.BuildSettings")) {
            GrailsVersion grailsVersion;
            currentVersion = grailsVersion = new GrailsVersion(Class.forName("grails.util.BuildSettings").getPackage().getImplementationVersion());
            return currentVersion;
        }
        return (GrailsVersion)ScriptBytecodeAdapter.castToType(null, GrailsVersion.class);
    }

    public boolean isSnapshot() {
        return this.snapshot != null;
    }

    @Override
    public int compareTo(GrailsVersion o) {
        int majorCompare = ScriptBytecodeAdapter.compareTo((Object)this.major, (Object)o.getMajor());
        if (majorCompare != 0) {
            return majorCompare;
        }
        int minorCompare = ScriptBytecodeAdapter.compareTo((Object)this.minor, (Object)o.getMinor());
        if (minorCompare != 0) {
            return minorCompare;
        }
        int patchCompare = ScriptBytecodeAdapter.compareTo((Object)this.patch, (Object)o.getPatch());
        if (patchCompare != 0) {
            return patchCompare;
        }
        if (this.isSnapshot() && !o.isSnapshot()) {
            return -1;
        }
        if (!this.isSnapshot() && o.isSnapshot()) {
            return 1;
        }
        if (this.isSnapshot() && o.isSnapshot()) {
            return this.getSnapshot() == o.getSnapshot() ? 0 : (this.getSnapshot() == null ? -1 : (o.getSnapshot() == null ? 1 : this.getSnapshot().compareTo(o.getSnapshot())));
        }
        return 0;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GrailsVersion.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public int hashCode() {
        int _result = HashCodeHelper.initHash();
        if (ScriptBytecodeAdapter.compareNotIdentical((Object)this.getVersionText(), (Object)this)) {
            int n;
            _result = n = HashCodeHelper.updateHash((int)_result, (Object)this.getVersionText());
        }
        return _result;
    }

    @Generated
    public boolean canEqual(Object other) {
        return other instanceof GrailsVersion;
    }

    @Generated
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof GrailsVersion)) {
            return false;
        }
        GrailsVersion otherTyped = (GrailsVersion)other;
        if (!otherTyped.canEqual(this)) {
            return false;
        }
        return !(!ScriptBytecodeAdapter.compareEqual((Object)this.getVersionText(), (Object)otherTyped.getVersionText()));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Object var0 = null;
        currentVersion = (GrailsVersion)ScriptBytecodeAdapter.castToType(var0, GrailsVersion.class);
    }

    @Generated
    public int getMajor() {
        return this.major;
    }

    @Generated
    public void setMajor(int n) {
        this.major = n;
    }

    @Generated
    public int getMinor() {
        return this.minor;
    }

    @Generated
    public void setMinor(int n) {
        this.minor = n;
    }

    @Generated
    public int getPatch() {
        return this.patch;
    }

    @Generated
    public void setPatch(int n) {
        this.patch = n;
    }

    @Generated
    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    @Generated
    public void setSnapshot(Snapshot snapshot) {
        this.snapshot = snapshot;
    }

    @Generated
    public String getVersionText() {
        return this.versionText;
    }

    @Generated
    public void setVersionText(String string) {
        this.versionText = string;
    }
}

