/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.AbstractBeanResolutionContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanIdentifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Internal
public final class DefaultBeanResolutionContext
extends AbstractBeanResolutionContext {
    private final Map<BeanIdentifier, Object> beansInCreation = new ConcurrentHashMap<BeanIdentifier, Object>(5);

    public DefaultBeanResolutionContext(BeanContext context, BeanDefinition rootDefinition) {
        super(context, rootDefinition);
    }

    public DefaultBeanResolutionContext(BeanContext context, BeanDefinition rootDefinition, Map<BeanIdentifier, Object> beansInCreation) {
        super(context, rootDefinition);
        if (beansInCreation != null) {
            this.beansInCreation.putAll(beansInCreation);
        }
    }

    @Override
    public BeanResolutionContext copy() {
        DefaultBeanResolutionContext copy = new DefaultBeanResolutionContext(this.context, this.rootDefinition);
        copy.copyStateFrom(this);
        return copy;
    }

    @Override
    public void close() {
        this.beansInCreation.clear();
    }

    @Override
    public <T> void addInFlightBean(BeanIdentifier beanIdentifier, T instance) {
        this.beansInCreation.put(beanIdentifier, instance);
    }

    @Override
    public void removeInFlightBean(BeanIdentifier beanIdentifier) {
        this.beansInCreation.remove(beanIdentifier);
    }

    @Override
    @Nullable
    public <T> T getInFlightBean(BeanIdentifier beanIdentifier) {
        return (T)this.beansInCreation.get(beanIdentifier);
    }
}

