/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.EnumElement;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;

@Internal
class JavaEnumElement
extends JavaClassElement
implements EnumElement {
    JavaEnumElement(TypeElement classElement, AnnotationMetadata annotationMetadata, JavaVisitorContext visitorContext) {
        this(classElement, annotationMetadata, visitorContext, 0);
    }

    JavaEnumElement(TypeElement classElement, AnnotationMetadata annotationMetadata, JavaVisitorContext visitorContext, int arrayDimensions) {
        super(classElement, annotationMetadata, visitorContext, Collections.emptyMap(), arrayDimensions, false);
    }

    public List<String> values() {
        TypeElement te = (TypeElement)this.getNativeType();
        List results = te.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.ENUM_CONSTANT).map(e -> e.getSimpleName().toString()).collect(Collectors.toList());
        return Collections.unmodifiableList(results);
    }

    @Override
    public ClassElement withArrayDimensions(int arrayDimensions) {
        return new JavaEnumElement(this.classElement, this.getAnnotationMetadata(), this.visitorContext, arrayDimensions);
    }
}

