/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.MessageSource;
import io.micronaut.core.util.ArgumentUtils;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;

public abstract class AbstractMessageSource
implements MessageSource {
    @Override
    @Nonnull
    public String interpolate(@Nonnull String template, @Nonnull MessageSource.MessageContext context) {
        boolean hasVar;
        ArgumentUtils.requireNonNull((String)"template", (Object)template);
        ArgumentUtils.requireNonNull((String)"context", (Object)context);
        int start = template.indexOf(123);
        int end = template.indexOf(125);
        boolean bl = hasVar = start < end;
        if (hasVar) {
            StringBuilder builder = new StringBuilder();
            while (hasVar) {
                if (start > 0) {
                    builder.append(template, 0, start);
                }
                String message = template.substring(start + 1, end);
                Object val = context.getVariables().get(message);
                if (val != null) {
                    builder.append(val);
                } else {
                    String resolved = this.getMessage(message, context).map(msg -> this.interpolate((String)msg, context)).orElse(message);
                    builder.append(resolved);
                }
                String remaining = template.substring(end + 1);
                start = remaining.indexOf(123);
                end = remaining.indexOf(125);
                boolean bl2 = hasVar = start < end;
                if (!hasVar) {
                    builder.append(remaining);
                    continue;
                }
                template = remaining;
            }
            return builder.toString();
        }
        return template;
    }

    protected final class MessageKey {
        final Locale locale;
        final String code;

        public MessageKey(@Nonnull Locale locale, String code) {
            this.locale = locale;
            this.code = code;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MessageKey key = (MessageKey)o;
            return this.locale.equals(key.locale) && this.code.equals(key.code);
        }

        public int hashCode() {
            return Objects.hash(this.locale, this.code);
        }
    }
}

