/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io;

import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.file.FileSystemResourceLoader;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import io.micronaut.core.util.ArgumentUtils;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class ResourceResolver {
    private final List<ResourceLoader> resourceLoaders;

    public ResourceResolver(@Nonnull ResourceLoader[] resourceLoaders) {
        this(Arrays.asList(resourceLoaders));
    }

    public ResourceResolver(@Nonnull List<ResourceLoader> resourceLoaders) {
        ArgumentUtils.requireNonNull("resourceLoaders", resourceLoaders);
        this.resourceLoaders = resourceLoaders;
    }

    public ResourceResolver() {
        this(new ResourceLoader[]{ClassPathResourceLoader.defaultLoader(ResourceResolver.class.getClassLoader()), FileSystemResourceLoader.defaultLoader()});
    }

    @Nonnull
    public <T extends ResourceLoader> Optional<T> getLoader(@Nonnull Class<T> resolverType) {
        ArgumentUtils.requireNonNull("resolverType", resolverType);
        return this.resourceLoaders.stream().filter(rl -> resolverType.isAssignableFrom(rl.getClass())).map(rl -> rl).findFirst();
    }

    @Nonnull
    public Optional<ResourceLoader> getSupportingLoader(@Nonnull String prefix) {
        ArgumentUtils.requireNonNull("prefix", prefix);
        return this.resourceLoaders.stream().filter(rl -> rl.supportsPrefix(prefix)).findFirst();
    }

    @Nonnull
    public Optional<ResourceLoader> getLoaderForBasePath(@Nonnull String basePath) {
        ArgumentUtils.requireNonNull("basePath", basePath);
        Optional<ResourceLoader> resourceLoader = this.getSupportingLoader(basePath);
        return resourceLoader.map(rl -> rl.forBase(basePath));
    }

    @Nonnull
    public Optional<InputStream> getResourceAsStream(@Nonnull String path) {
        ArgumentUtils.requireNonNull("path", path);
        Optional<ResourceLoader> resourceLoader = this.getSupportingLoader(path);
        if (resourceLoader.isPresent()) {
            return resourceLoader.get().getResourceAsStream(path);
        }
        return Optional.empty();
    }

    @Nonnull
    public Optional<URL> getResource(@Nonnull String path) {
        ArgumentUtils.requireNonNull("path", path);
        Optional<ResourceLoader> resourceLoader = this.getSupportingLoader(path);
        if (resourceLoader.isPresent()) {
            return resourceLoader.get().getResource(path);
        }
        return Optional.empty();
    }

    @Nonnull
    public Stream<URL> getResources(@Nonnull String path) {
        ArgumentUtils.requireNonNull("path", path);
        Optional<ResourceLoader> resourceLoader = this.getSupportingLoader(path);
        if (resourceLoader.isPresent()) {
            return resourceLoader.get().getResources(path);
        }
        return Stream.empty();
    }
}

