/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanWrapper;
import io.micronaut.core.util.ArgumentUtils;
import java.util.Objects;
import javax.annotation.Nonnull;

@Internal
final class DefaultBeanWrapper<T>
implements BeanWrapper<T> {
    private final T bean;
    private final BeanIntrospection<T> introspection;

    DefaultBeanWrapper(@Nonnull T bean, @Nonnull BeanIntrospection<T> introspection) {
        ArgumentUtils.requireNonNull("bean", bean);
        ArgumentUtils.requireNonNull("introspection", introspection);
        this.bean = bean;
        this.introspection = introspection;
    }

    @Override
    @Nonnull
    public BeanIntrospection<T> getIntrospection() {
        return this.introspection;
    }

    @Override
    @Nonnull
    public T getBean() {
        return this.bean;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultBeanWrapper that = (DefaultBeanWrapper)o;
        return Objects.equals(this.bean, that.bean) && Objects.equals(this.introspection, that.introspection);
    }

    public int hashCode() {
        return Objects.hash(this.bean, this.introspection);
    }
}

