/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.simple;

import java.util.Map;
import org.grails.datastore.mapping.core.AbstractSession;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.engine.Persister;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.simple.SimpleMapDatastore;
import org.grails.datastore.mapping.simple.engine.SimpleMapEntityPersister;
import org.grails.datastore.mapping.transactions.Transaction;
import org.springframework.context.ApplicationEventPublisher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMapSession
extends AbstractSession<Map> {
    private Map<String, Map> datastore;

    public SimpleMapSession(SimpleMapDatastore datastore, MappingContext mappingContext, ApplicationEventPublisher publisher) {
        super((Datastore)datastore, mappingContext, publisher);
        this.datastore = datastore.getBackingMap();
    }

    protected Persister createPersister(Class cls, MappingContext mappingContext) {
        PersistentEntity entity = mappingContext.getPersistentEntity(cls.getName());
        if (entity == null) {
            return null;
        }
        return new SimpleMapEntityPersister(mappingContext, entity, (Session)this, (SimpleMapDatastore)this.getDatastore(), this.publisher);
    }

    public Map<String, Map> getBackingMap() {
        return this.datastore;
    }

    protected Transaction beginTransactionInternal() {
        return new MockTransaction(this);
    }

    public Map getNativeInterface() {
        return this.datastore;
    }

    private class MockTransaction
    implements Transaction {
        public MockTransaction(SimpleMapSession simpleMapSession2) {
        }

        public void commit() {
        }

        public void rollback() {
        }

        public Object getNativeTransaction() {
            return this;
        }

        public boolean isActive() {
            return true;
        }

        public void setTimeout(int timeout) {
        }
    }
}

