/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.converters.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.grails.support.proxy.DefaultProxyHandler;
import org.codehaus.groovy.grails.support.proxy.ProxyHandler;
import org.codehaus.groovy.grails.web.converters.Converter;
import org.codehaus.groovy.grails.web.converters.configuration.ConverterConfiguration;
import org.codehaus.groovy.grails.web.converters.exceptions.ConverterException;
import org.codehaus.groovy.grails.web.converters.marshaller.ObjectMarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedConverterConfiguration<C extends Converter>
implements ConverterConfiguration<C> {
    private List<ObjectMarshaller<C>> marshallerList;
    private ChainedObjectMarshaller<C> root;
    private final String encoding;
    private final Converter.CircularReferenceBehaviour circularReferenceBehaviour;
    private final boolean prettyPrint;
    private ProxyHandler proxyHandler;

    public ChainedConverterConfiguration(ConverterConfiguration<C> cfg) {
        this(cfg, (ProxyHandler)new DefaultProxyHandler());
    }

    public ChainedConverterConfiguration(ConverterConfiguration<C> cfg, ProxyHandler proxyHandler) {
        this.marshallerList = cfg.getOrderedObjectMarshallers();
        this.proxyHandler = proxyHandler;
        this.encoding = cfg.getEncoding();
        this.prettyPrint = cfg.isPrettyPrint();
        this.circularReferenceBehaviour = cfg.getCircularReferenceBehaviour();
        ArrayList<ObjectMarshaller<C>> oms = new ArrayList<ObjectMarshaller<C>>(this.marshallerList);
        Collections.reverse(oms);
        ChainedObjectMarshaller prev = null;
        for (ObjectMarshaller objectMarshaller : oms) {
            prev = new ChainedObjectMarshaller(objectMarshaller, prev);
        }
        this.root = prev;
    }

    @Override
    public ObjectMarshaller<C> getMarshaller(Object o) {
        return this.root.findMarhallerFor(o);
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public Converter.CircularReferenceBehaviour getCircularReferenceBehaviour() {
        return this.circularReferenceBehaviour;
    }

    @Override
    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    @Override
    public List<ObjectMarshaller<C>> getOrderedObjectMarshallers() {
        return this.marshallerList;
    }

    @Override
    public ProxyHandler getProxyHandler() {
        return this.proxyHandler;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChainedObjectMarshaller<C extends Converter>
    implements ObjectMarshaller<C> {
        private ObjectMarshaller<C> om;
        private ChainedObjectMarshaller<C> next;

        public ChainedObjectMarshaller(ObjectMarshaller<C> om, ChainedObjectMarshaller<C> next) {
            this.om = om;
            this.next = next;
        }

        public ObjectMarshaller<C> findMarhallerFor(Object o) {
            if (this.supports(o)) {
                return this.om;
            }
            return this.next != null ? this.next.findMarhallerFor(o) : null;
        }

        @Override
        public boolean supports(Object object) {
            return this.om.supports(object);
        }

        @Override
        public void marshalObject(Object object, C converter) throws ConverterException {
            this.om.marshalObject(object, converter);
        }
    }
}

