/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.builder;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;

public class BinderConfiguration {
    private Set bindings = new LinkedHashSet();

    public void addBinding(Binding binding) {
        this.bindings.add(binding);
    }

    public Set getBindings() {
        return this.bindings;
    }

    public Binding getBinding(String name) {
        Iterator it = this.bindings.iterator();
        while (it.hasNext()) {
            Binding binding = (Binding)it.next();
            if (!name.equals(binding.getProperty())) continue;
            return binding;
        }
        return null;
    }

    public static final class Binding {
        private String property;
        private String converter;
        private boolean required;

        public Binding(String property, String converter, boolean required) {
            Assert.hasText((String)property, (String)"The property is required");
            this.property = property;
            this.converter = converter;
            this.required = required;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Binding)) {
                return false;
            }
            Binding binding = (Binding)object;
            return this.property.equals(binding.property);
        }

        public int hashCode() {
            return this.property.hashCode();
        }

        public String getProperty() {
            return this.property;
        }

        public String getConverter() {
            return this.converter;
        }

        public boolean getRequired() {
            return this.required;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("property", (Object)this.property).append("converter", (Object)this.converter).append("required", this.required).toString();
        }
    }
}

