/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ops;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.EPUBProfile;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.OPFChecker;
import com.adobe.epubcheck.opf.OPFChecker30;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.ops.OPSHandler;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.util.SourceSet;
import com.adobe.epubcheck.vocab.AggregateVocab;
import com.adobe.epubcheck.vocab.AltStylesheetVocab;
import com.adobe.epubcheck.vocab.ComicsVocab;
import com.adobe.epubcheck.vocab.DataNavVocab;
import com.adobe.epubcheck.vocab.DictVocab;
import com.adobe.epubcheck.vocab.EpubCheckVocab;
import com.adobe.epubcheck.vocab.ForeignVocabs;
import com.adobe.epubcheck.vocab.IndexVocab;
import com.adobe.epubcheck.vocab.MagazineNavigationVocab;
import com.adobe.epubcheck.vocab.PackageVocabs;
import com.adobe.epubcheck.vocab.Property;
import com.adobe.epubcheck.vocab.StagingEdupubVocab;
import com.adobe.epubcheck.vocab.StructureVocab;
import com.adobe.epubcheck.vocab.Vocab;
import com.adobe.epubcheck.vocab.VocabUtil;
import com.adobe.epubcheck.xml.XMLAttribute;
import com.adobe.epubcheck.xml.XMLElement;
import com.adobe.epubcheck.xml.XMLParser;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OPSHandler30
extends OPSHandler {
    private static final Pattern DATA_URI_PATTERN = Pattern.compile("^data:([^;]*)[^,]*,.*");
    private static Map<String, Vocab> RESERVED_VOCABS = ImmutableMap.of("", AggregateVocab.of(StructureVocab.VOCAB, StagingEdupubVocab.VOCAB, DataNavVocab.VOCAB, DictVocab.VOCAB, IndexVocab.VOCAB, ComicsVocab.VOCAB, StructureVocab.UNCHECKED_VOCAB), "msv", MagazineNavigationVocab.VOCAB, "prism", ForeignVocabs.PRISM_VOCAB);
    private static Map<String, Vocab> ALTCSS_VOCABS = ImmutableMap.of("", AltStylesheetVocab.VOCAB);
    private static Map<String, Vocab> KNOWN_VOCAB_URIS = ImmutableMap.of("http://www.idpf.org/epub/vocab/structure/magazine/#", MagazineNavigationVocab.VOCAB, "http://www.prismstandard.org/specifications/3.0/PRISM_CV_Spec_3.0.htm#", ForeignVocabs.PRISM_VOCAB);
    private static Set<String> DEFAULT_VOCAB_URIS = ImmutableSet.of("http://www.idpf.org/epub/vocab/structure/#");
    private Map<String, Vocab> vocabs = RESERVED_VOCABS;
    private final Set<PackageVocabs.ITEM_PROPERTIES> requiredProperties = EnumSet.noneOf(PackageVocabs.ITEM_PROPERTIES.class);
    private final Set<PackageVocabs.ITEM_PROPERTIES> allowedProperties = EnumSet.noneOf(PackageVocabs.ITEM_PROPERTIES.class);
    private final boolean isLinear;
    protected boolean inVideo = false;
    protected boolean inAudio = false;
    protected boolean inPicture = false;
    protected boolean hasValidFallback = false;
    protected int imbricatedObjects = 0;
    protected int imbricatedCanvases = 0;
    protected boolean anchorNeedsText = false;
    protected boolean inMathML = false;
    protected boolean inSvg = false;
    protected boolean inBody = false;
    protected boolean inRegionBasedNav = false;
    protected boolean isOutermostSVGAlreadyProcessed = false;
    protected boolean hasAltorAnnotation = false;
    protected boolean hasTitle = false;
    protected static final String[] scriptEventsStrings = new String[]{"onafterprint", "onbeforeprint", "onbeforeunload", "onerror", "onhaschange", "onload", "onmessage", "onoffline", "onpagehide", "onpageshow", "onpopstate", "onredo", "onresize", "onstorage", "onundo", "onunload", "onblur", "onchange", "oncontextmenu", "onfocus", "onformchange", "onforminput", "oninput", "oninvalid", "onreset", "onselect", "onsubmit", "onkeydown", "onkeypress", "onkeyup", "onabort", "oncanplay", "oncanplaythrough", "ondurationchange", "onemptied", "onended", "onerror", "onloadeddata", "onloadedmetadata", "onloadstart", "onpause", "onplay", "onplaying", "onprogress", "onratechange", "onreadystatechange", "onseeked", "onseeking", "onstalled", "onsuspend", "ontimeupdate", "onvolumechange", "onwaiting"};
    protected static HashSet<String> scriptEvents;
    protected static final String[] mouseEventsStrings;
    protected static HashSet<String> mouseEvents;

    public static HashSet<String> getScriptEvents() {
        if (scriptEvents == null) {
            scriptEvents = new HashSet();
            Collections.addAll(scriptEvents, scriptEventsStrings);
            Collections.addAll(scriptEvents, mouseEventsStrings);
        }
        return scriptEvents;
    }

    public static HashSet<String> getMouseEvents() {
        if (mouseEvents == null) {
            mouseEvents = new HashSet();
            Collections.addAll(mouseEvents, mouseEventsStrings);
        }
        return mouseEvents;
    }

    public OPSHandler30(ValidationContext context, XMLParser parser) {
        super(context, parser);
        this.checkedUnsupportedXMLVersion = false;
        this.isLinear = !context.properties.contains(EpubCheckVocab.VOCAB.get(EpubCheckVocab.PROPERTIES.NON_LINEAR));
    }

    @Override
    protected void checkImage(XMLElement e, String attrNS, String attr) {
        String ns = e.getNamespace();
        if ("http://www.w3.org/2000/svg".equals(ns)) {
            super.checkImage(e, attrNS, attr);
        } else if (this.xrefChecker.isPresent()) {
            String src = e.getAttribute("src");
            String srcset = e.getAttribute("srcset");
            if (this.inPicture) {
                String type = e.getAttribute("type");
                if ("source".equals(e.getName()) && type != null && !OPFChecker.isBlessedImageType(type)) {
                    this.registerImageSources(src, srcset, XRefChecker.Type.PICTURE_SOURCE_FOREIGN);
                } else {
                    this.registerImageSources(src, srcset, XRefChecker.Type.PICTURE_SOURCE);
                }
            } else {
                this.registerImageSources(src, srcset, XRefChecker.Type.IMAGE);
            }
        }
    }

    protected void registerImageSources(String src, String srcset, XRefChecker.Type type) {
        TreeSet<String> urls = new TreeSet<String>();
        if (src != null) {
            urls.add(src);
        }
        urls.addAll(SourceSet.parse(srcset).getImageURLs());
        for (String url : urls) {
            ((XRefChecker)this.xrefChecker.get()).registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), PathUtil.resolveRelativeReference(this.base, url), type);
        }
    }

    protected void checkType(XMLElement e, String type) {
        if (type == null) {
            return;
        }
        Set<Property> propList = VocabUtil.parsePropertyList(type, this.vocabs, this.context, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()));
        this.checkTypes(Property.filter(propList, StructureVocab.EPUB_TYPES.class));
        for (Property property : propList) {
            if (!"http://www.idpf.org/epub/vocab/structure/#".equals(property.getVocabURI())) continue;
            try {
                property.toEnum();
            }
            catch (UnsupportedOperationException ex) {
                this.report.message(MessageId.OPF_088, this.parser.getLocation(), property.getName());
            }
        }
        if (propList.contains(DataNavVocab.VOCAB.get(DataNavVocab.EPUB_TYPES.REGION_BASED))) {
            if (!"nav".equals(e.getName()) || !this.context.properties.contains(PackageVocabs.ITEM_VOCAB.get(PackageVocabs.ITEM_PROPERTIES.DATA_NAV))) {
                this.report.message(MessageId.HTM_052, this.parser.getLocation(), new Object[0]);
            } else {
                this.inRegionBasedNav = true;
            }
        }
        if (propList.contains(DictVocab.VOCAB.get(DictVocab.EPUB_TYPES.DICTIONARY))) {
            this.context.featureReport.report(FeatureEnum.DICTIONARY, this.parser.getLocation(), null);
        }
    }

    protected void checkTypes(Set<StructureVocab.EPUB_TYPES> types) {
        if (types.contains(StructureVocab.EPUB_TYPES.PAGEBREAK)) {
            this.context.featureReport.report(FeatureEnum.PAGE_BREAK, this.parser.getLocation(), null);
        }
        if (types.contains(StructureVocab.EPUB_TYPES.INDEX)) {
            this.allowedProperties.add(PackageVocabs.ITEM_PROPERTIES.INDEX);
            this.context.featureReport.report(FeatureEnum.INDEX, this.parser.getLocation(), null);
        }
    }

    @Override
    protected void checkSVGFontFaceURI(XMLElement e, String attrNS, String attr) {
        super.checkSVGFontFaceURI(e, attrNS, attr);
        String href = e.getAttributeNS(attrNS, attr);
        if (href != null && PathUtil.isRemote(href)) {
            this.requiredProperties.add(PackageVocabs.ITEM_PROPERTIES.REMOTE_RESOURCES);
        }
    }

    protected void checkSSMLPh(String ph) {
        if (ph == null) {
            return;
        }
        if (ph.trim().length() < 1) {
            this.report.message(MessageId.HTM_007, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()), new Object[0]);
        }
    }

    @Override
    public void characters(char[] chars, int arg1, int arg2) {
        super.characters(chars, arg1, arg2);
        String str = new String(chars, arg1, arg2);
        str = str.trim();
        if (!str.equals("") && (this.inAudio || this.inVideo || this.imbricatedObjects > 0 || this.imbricatedCanvases > 0)) {
            this.hasValidFallback = true;
        }
        if (this.anchorNeedsText) {
            this.anchorNeedsText = false;
        }
    }

    @Override
    public void startElement() {
        super.startElement();
        XMLElement e = this.parser.getCurrentElement();
        String name = e.getName();
        this.processSemantics(e);
        this.processSectioning(e);
        if (name.equals("html")) {
            this.vocabs = VocabUtil.parsePrefixDeclaration(e.getAttributeNS("http://www.idpf.org/2007/ops", "prefix"), RESERVED_VOCABS, KNOWN_VOCAB_URIS, DEFAULT_VOCAB_URIS, this.report, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()));
        } else if (name.equals("link")) {
            this.processLink(e);
        } else if (name.equals("object")) {
            this.processObject(e);
        } else if (name.equals("math")) {
            this.requiredProperties.add(PackageVocabs.ITEM_PROPERTIES.MATHML);
            this.inMathML = true;
            this.hasAltorAnnotation = null != e.getAttribute("alttext");
        } else if (name.equals("svg")) {
            this.processSVG(e);
        } else if ("http://www.idpf.org/2007/ops".equals(e.getNamespace()) && name.equals("switch")) {
            this.requiredProperties.add(PackageVocabs.ITEM_PROPERTIES.SWITCH);
        } else if (name.equals("audio")) {
            this.processAudio();
        } else if (name.equals("video")) {
            this.processVideo(e);
        } else if (name.equals("figure")) {
            this.processFigure(e);
        } else if (name.equals("table")) {
            this.processTable(e);
        } else if (name.equals("canvas")) {
            this.processCanvas();
        } else if (name.equals("img")) {
            this.processImg();
        } else if (name.equals("a")) {
            this.anchorNeedsText = true;
            this.processAnchor(e);
        } else if (name.equals("annotation-xml")) {
            this.hasAltorAnnotation = true;
        } else if (name.equals("picture")) {
            this.inPicture = true;
        } else if (name.equals("source")) {
            if (this.inPicture) {
                this.checkImage(e, null, null);
            }
        } else if ("http://www.w3.org/2000/svg".equals(e.getNamespace()) && name.equals("title")) {
            this.hasTitle = true;
        }
        this.processInlineScripts(e);
        this.processSrc("source".equals(name) ? e.getParent().getName() : name, e.getAttribute("src"));
        this.checkType(e, e.getAttributeNS("http://www.idpf.org/2007/ops", "type"));
        this.checkSSMLPh(e.getAttributeNS("http://www.w3.org/2001/10/synthesis", "ph"));
    }

    protected void processInlineScripts(XMLElement e) {
        HashSet<String> scriptEvents = OPSHandler30.getScriptEvents();
        HashSet<String> mouseEvents = OPSHandler30.getMouseEvents();
        for (int i = 0; i < e.getAttributeCount(); ++i) {
            XMLAttribute attr = e.getAttribute(i);
            String name = attr.getName().toLowerCase(Locale.ROOT);
            if (!scriptEvents.contains(name) && !mouseEvents.contains(name)) continue;
            this.processJavascript();
            return;
        }
    }

    @Override
    protected void processJavascript() {
        super.processJavascript();
        this.requiredProperties.add(PackageVocabs.ITEM_PROPERTIES.SCRIPTED);
    }

    protected void processLink(XMLElement e) {
        String classAttribute = e.getAttribute("class");
        if (classAttribute == null) {
            return;
        }
        Set<Property> properties = VocabUtil.parsePropertyList(classAttribute, ALTCSS_VOCABS, this.context, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()));
        Set<AltStylesheetVocab.PROPERTIES> altClasses = Property.filter(properties, AltStylesheetVocab.PROPERTIES.class);
        if (properties.size() == 1) {
            return;
        }
        boolean vertical = altClasses.contains((Object)AltStylesheetVocab.PROPERTIES.VERTICAL);
        boolean horizontal = altClasses.contains((Object)AltStylesheetVocab.PROPERTIES.HORIZONTAL);
        boolean day = altClasses.contains((Object)AltStylesheetVocab.PROPERTIES.DAY);
        boolean night = altClasses.contains((Object)AltStylesheetVocab.PROPERTIES.NIGHT);
        if (vertical && horizontal || day && night) {
            this.report.message(MessageId.CSS_005, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()), classAttribute);
        }
    }

    protected void processAnchor(XMLElement e) {
        if (e.getAttribute("href") == null) {
            this.anchorNeedsText = false;
        }
        if (this.inSvg || this.context.mimeType.equals("image/svg+xml")) {
            this.hasTitle = Strings.emptyToNull(e.getAttributeNS("http://www.w3.org/1999/xlink", "title")) != null;
        }
    }

    protected void processImg() {
        if (this.inAudio || this.inVideo || this.imbricatedObjects > 0 || this.imbricatedCanvases > 0) {
            this.hasValidFallback = true;
        }
    }

    protected void processCanvas() {
        ++this.imbricatedCanvases;
    }

    protected void processAudio() {
        this.inAudio = true;
        this.context.featureReport.report(FeatureEnum.AUDIO, this.parser.getLocation());
    }

    protected void processVideo(XMLElement e) {
        this.inVideo = true;
        this.context.featureReport.report(FeatureEnum.VIDEO, this.parser.getLocation());
        String posterSrc = e.getAttribute("poster");
        String posterMimeType = null;
        if (this.xrefChecker.isPresent() && posterSrc != null) {
            posterMimeType = ((XRefChecker)this.xrefChecker.get()).getMimeType(PathUtil.resolveRelativeReference(this.base, posterSrc));
        }
        if (posterMimeType != null && !OPFChecker.isBlessedImageType(posterMimeType)) {
            this.report.message(MessageId.MED_001, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()), new Object[0]);
        }
        if (posterSrc != null) {
            this.hasValidFallback = true;
            this.processSrc(e.getName(), posterSrc);
        }
    }

    @Override
    protected void processHyperlink(String href) {
        super.processHyperlink(href);
        if (this.inRegionBasedNav && this.xrefChecker.isPresent()) {
            ((XRefChecker)this.xrefChecker.get()).registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href, XRefChecker.Type.REGION_BASED_NAV);
        }
    }

    protected void processSrc(String name, String src) {
        if (src != null && (src = src.trim()).equals("")) {
            this.report.message(MessageId.HTM_008, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), name), new Object[0]);
        }
        if (src == null || !this.xrefChecker.isPresent()) {
            return;
        }
        String srcMimeType = null;
        Matcher matcher = DATA_URI_PATTERN.matcher(src);
        if (matcher.matches()) {
            srcMimeType = matcher.group(1);
        } else {
            if (PathUtil.isRemote(src)) {
                this.requiredProperties.add(PackageVocabs.ITEM_PROPERTIES.REMOTE_RESOURCES);
            } else {
                src = PathUtil.resolveRelativeReference(this.base, src);
            }
            XRefChecker.Type refType = "audio".equals(name) ? XRefChecker.Type.AUDIO : ("video".equals(name) ? XRefChecker.Type.VIDEO : XRefChecker.Type.GENERIC);
            if (!"img".equals(name)) {
                ((XRefChecker)this.xrefChecker.get()).registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), src, refType);
            }
            srcMimeType = ((XRefChecker)this.xrefChecker.get()).getMimeType(src);
        }
        if (srcMimeType == null) {
            return;
        }
        if (!this.context.mimeType.equals("image/svg+xml") && srcMimeType.equals("image/svg+xml")) {
            this.allowedProperties.add(PackageVocabs.ITEM_PROPERTIES.SVG);
        }
        if ((this.inAudio || this.inVideo || this.imbricatedObjects > 0 || this.imbricatedCanvases > 0) && OPFChecker30.isCoreMediaType(srcMimeType) && !name.equals("track")) {
            this.hasValidFallback = true;
        }
    }

    protected void processObject(XMLElement e) {
        ++this.imbricatedObjects;
        String type = e.getAttribute("type");
        String data = e.getAttribute("data");
        if (data != null) {
            this.processSrc(e.getName(), data);
            data = PathUtil.resolveRelativeReference(this.base, data);
        }
        if (type != null && data != null && this.xrefChecker.isPresent() && !type.equals(((XRefChecker)this.xrefChecker.get()).getMimeType(data))) {
            String context = "<object";
            for (int i = 0; i < e.getAttributeCount(); ++i) {
                XMLAttribute attribute = e.getAttribute(i);
                context = context + " " + attribute.getName() + "=\"" + attribute.getValue() + "\"";
            }
            context = context + ">";
            this.report.message(MessageId.OPF_013, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), context), type, ((XRefChecker)this.xrefChecker.get()).getMimeType(data));
        }
        if (type != null) {
            if (!this.context.mimeType.equals("image/svg+xml") && type.equals("image/svg+xml")) {
                this.allowedProperties.add(PackageVocabs.ITEM_PROPERTIES.SVG);
            }
            if (OPFChecker30.isCoreMediaType(type)) {
                this.hasValidFallback = true;
            }
        }
        if (this.hasValidFallback) {
            return;
        }
        if (this.xrefChecker.isPresent() && type != null && ((XRefChecker)this.xrefChecker.get()).getBindingHandlerId(type) != null) {
            this.hasValidFallback = true;
        }
    }

    protected void processSVG(XMLElement e) {
        this.inSvg = true;
        if (!this.context.mimeType.equals("image/svg+xml")) {
            this.requiredProperties.add(PackageVocabs.ITEM_PROPERTIES.SVG);
        } else if (!this.isOutermostSVGAlreadyProcessed) {
            this.isOutermostSVGAlreadyProcessed = true;
            if (this.context.opfItem.isPresent() && this.context.opfItem.get().isFixedLayout() && e.getAttribute("viewBox") == null) {
                this.report.message(MessageId.HTM_048, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()), new Object[0]);
            }
        }
    }

    protected void processTable(XMLElement e) {
        this.context.featureReport.report(FeatureEnum.TABLE, this.parser.getLocation());
    }

    protected void processFigure(XMLElement e) {
        this.context.featureReport.report(FeatureEnum.FIGURE, this.parser.getLocation());
    }

    private void processSemantics(XMLElement e) {
        if (e.getAttribute("itemscope") != null && !this.context.featureReport.hasFeature(FeatureEnum.HAS_MICRODATA)) {
            this.context.featureReport.report(FeatureEnum.HAS_MICRODATA, this.parser.getLocation());
        }
        if (e.getAttribute("property") != null && !this.context.featureReport.hasFeature(FeatureEnum.HAS_RDFA)) {
            this.context.featureReport.report(FeatureEnum.HAS_RDFA, this.parser.getLocation());
        }
    }

    private void processSectioning(XMLElement e) {
        if (this.isLinear && this.context.profile == EPUBProfile.EDUPUB && "http://www.w3.org/1999/xhtml".equals(e.getNamespace())) {
            if ("body".equals(e.getName())) {
                this.inBody = true;
            } else if (this.inBody && !"section".equals(e.getName())) {
                this.context.featureReport.report(FeatureEnum.SECTIONS, this.parser.getLocation());
                this.inBody = false;
            } else if ("section".equals(e.getName())) {
                this.inBody = false;
                this.context.featureReport.report(FeatureEnum.SECTIONS, this.parser.getLocation());
            }
        }
    }

    @Override
    public void endElement() {
        super.endElement();
        XMLElement e = this.parser.getCurrentElement();
        String name = e.getName();
        if (this.openElements == 0L && (name.equals("html") || name.equals("svg"))) {
            this.checkProperties();
        } else if (name.equals("object")) {
            --this.imbricatedObjects;
            if (this.imbricatedObjects == 0 && this.imbricatedCanvases == 0) {
                this.checkFallback("Object");
            }
        } else if (name.equals("canvas")) {
            --this.imbricatedCanvases;
            if (this.imbricatedObjects == 0 && this.imbricatedCanvases == 0) {
                this.checkFallback("Canvas");
            }
        } else if (name.equals("video")) {
            if (this.imbricatedObjects == 0 && this.imbricatedCanvases == 0) {
                this.checkFallback("Video");
            }
            this.inVideo = false;
        } else if (name.equals("audio")) {
            if (this.imbricatedObjects == 0 && this.imbricatedCanvases == 0) {
                this.checkFallback("Audio");
            }
            this.inAudio = false;
        } else if (name.equals("a")) {
            if (this.anchorNeedsText) {
                this.report.message(MessageId.ACC_004, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), "a"), new Object[0]);
                this.anchorNeedsText = false;
            }
            if ((this.inSvg || this.context.mimeType.equals("image/svg+xml")) && !this.hasTitle) {
                this.report.message(MessageId.ACC_011, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), e.getName()), new Object[0]);
            }
        } else if (name.equals("math")) {
            this.inMathML = false;
            if (!this.hasAltorAnnotation) {
                this.report.message(MessageId.ACC_009, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), "math"), new Object[0]);
            }
        } else if (name.equals("nav") && this.inRegionBasedNav) {
            this.inRegionBasedNav = false;
        } else if (name.equals("picture")) {
            this.inPicture = false;
        } else if (name.equals("svg")) {
            this.inSvg = false;
        }
    }

    protected void checkFallback(String elementType) {
        if (this.hasValidFallback) {
            this.hasValidFallback = false;
        } else {
            this.report.message(MessageId.MED_002, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()), elementType);
        }
    }

    protected void checkProperties() {
        if (!this.context.ocf.isPresent()) {
            return;
        }
        Set<PackageVocabs.ITEM_PROPERTIES> itemProps = Property.filter(this.context.properties, PackageVocabs.ITEM_PROPERTIES.class);
        for (PackageVocabs.ITEM_PROPERTIES requiredProperty : Sets.difference(this.requiredProperties, itemProps)) {
            this.report.message(MessageId.OPF_014, EPUBLocation.create(this.path), PackageVocabs.ITEM_VOCAB.getName(requiredProperty));
        }
        EnumSet<PackageVocabs.ITEM_PROPERTIES> uncheckedProperties = Sets.difference(itemProps, this.requiredProperties).copyInto(EnumSet.noneOf(PackageVocabs.ITEM_PROPERTIES.class));
        uncheckedProperties.remove((Object)PackageVocabs.ITEM_PROPERTIES.NAV);
        uncheckedProperties.remove((Object)PackageVocabs.ITEM_PROPERTIES.DATA_NAV);
        uncheckedProperties.remove((Object)PackageVocabs.ITEM_PROPERTIES.COVER_IMAGE);
        uncheckedProperties.removeAll(this.allowedProperties);
        if (uncheckedProperties.contains((Object)PackageVocabs.ITEM_PROPERTIES.REMOTE_RESOURCES)) {
            uncheckedProperties.remove((Object)PackageVocabs.ITEM_PROPERTIES.REMOTE_RESOURCES);
            if (!this.requiredProperties.contains((Object)PackageVocabs.ITEM_PROPERTIES.SCRIPTED)) {
                this.report.message(MessageId.OPF_018, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()), new Object[0]);
            } else {
                this.report.message(MessageId.OPF_018b, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()), new Object[0]);
            }
        }
        if (!uncheckedProperties.isEmpty()) {
            this.report.message(MessageId.OPF_015, EPUBLocation.create(this.path), Joiner.on(", ").join(PackageVocabs.ITEM_VOCAB.getNames(uncheckedProperties)));
        }
    }

    static {
        mouseEventsStrings = new String[]{"onclick", "ondblclick", "ondrag", "ondragend", "ondragenter", "ondragleave", "ondragover", "ondragstart", "ondrop", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onmousewheel", "onscroll"};
    }
}

