/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.expressions;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.ExpressionFunctionValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Explanation;

final class ExpressionValueSource
extends DoubleValuesSource {
    final DoubleValuesSource[] variables;
    final Expression expression;
    final boolean needsScores;

    ExpressionValueSource(Bindings bindings, Expression expression) {
        if (bindings == null) {
            throw new NullPointerException();
        }
        this.expression = Objects.requireNonNull(expression);
        this.variables = new DoubleValuesSource[expression.variables.length];
        boolean needsScores = false;
        for (int i = 0; i < this.variables.length; ++i) {
            DoubleValuesSource source = bindings.getDoubleValuesSource(expression.variables[i]);
            if (source == null) {
                throw new RuntimeException("Internal error. Variable (" + expression.variables[i] + ") does not exist.");
            }
            needsScores |= source.needsScores();
            this.variables[i] = source;
        }
        this.needsScores = needsScores;
    }

    public DoubleValues getValues(LeafReaderContext readerContext, DoubleValues scores) throws IOException {
        HashMap<String, DoubleValues> valuesCache = new HashMap<String, DoubleValues>();
        DoubleValues[] externalValues = new DoubleValues[this.expression.variables.length];
        for (int i = 0; i < this.variables.length; ++i) {
            String externalName = this.expression.variables[i];
            DoubleValues values = (DoubleValues)valuesCache.get(externalName);
            if (values == null) {
                values = this.variables[i].getValues(readerContext, scores);
                if (values == null) {
                    throw new RuntimeException("Internal error. External (" + externalName + ") does not exist.");
                }
                valuesCache.put(externalName, values);
            }
            externalValues[i] = ExpressionValueSource.zeroWhenUnpositioned(values);
        }
        return new ExpressionFunctionValues(this.expression, externalValues);
    }

    private static DoubleValues zeroWhenUnpositioned(final DoubleValues in) {
        return new DoubleValues(){
            boolean positioned = false;

            public double doubleValue() throws IOException {
                return this.positioned ? in.doubleValue() : 0.0;
            }

            public boolean advanceExact(int doc) throws IOException {
                this.positioned = in.advanceExact(doc);
                return this.positioned;
            }
        };
    }

    public String toString() {
        return "expr(" + this.expression.sourceText + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.needsScores ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.variables);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ExpressionValueSource other = (ExpressionValueSource)((Object)obj);
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        if (this.needsScores != other.needsScores) {
            return false;
        }
        return Arrays.equals(this.variables, other.variables);
    }

    public boolean needsScores() {
        return this.needsScores;
    }

    public Explanation explain(LeafReaderContext ctx, int docId, Explanation scoreExplanation) throws IOException {
        Explanation[] explanations = new Explanation[this.variables.length];
        DoubleValues dv = this.getValues(ctx, DoubleValuesSource.constant((double)scoreExplanation.getValue()).getValues(ctx, null));
        if (!dv.advanceExact(docId)) {
            return Explanation.noMatch((String)this.expression.sourceText, (Explanation[])new Explanation[0]);
        }
        int i = 0;
        for (DoubleValuesSource var : this.variables) {
            explanations[i++] = var.explain(ctx, docId, scoreExplanation);
        }
        return Explanation.match((float)((float)dv.doubleValue()), (String)(this.expression.sourceText + ", computed from:"), (Explanation[])explanations);
    }
}

