/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls.attribute;

import com.vladium.jcd.cls.ClassDef;
import com.vladium.jcd.cls.IConstantCollection;
import com.vladium.jcd.cls.attribute.BridgeAttribute_info;
import com.vladium.jcd.cls.attribute.CodeAttribute_info;
import com.vladium.jcd.cls.attribute.ConstantValueAttribute_info;
import com.vladium.jcd.cls.attribute.ExceptionsAttribute_info;
import com.vladium.jcd.cls.attribute.GenericAttribute_info;
import com.vladium.jcd.cls.attribute.IAttributeVisitor;
import com.vladium.jcd.cls.attribute.InnerClassesAttribute_info;
import com.vladium.jcd.cls.attribute.LineNumberTableAttribute_info;
import com.vladium.jcd.cls.attribute.SourceFileAttribute_info;
import com.vladium.jcd.cls.attribute.SyntheticAttribute_info;
import com.vladium.jcd.cls.constant.CONSTANT_Utf8_info;
import com.vladium.jcd.compiler.IClassFormatOutput;
import com.vladium.jcd.lib.UDataInputStream;
import com.vladium.jcd.lib.UDataOutputStream;
import java.io.IOException;

public abstract class Attribute_info
implements Cloneable,
IClassFormatOutput {
    public static final String ATTRIBUTE_CODE = "Code";
    public static final String ATTRIBUTE_CONSTANT_VALUE = "ConstantValue";
    public static final String ATTRIBUTE_LINE_NUMBER_TABLE = "LineNumberTable";
    public static final String ATTRIBUTE_EXCEPTIONS = "Exceptions";
    public static final String ATTRIBUTE_SYNTHETIC = "Synthetic";
    public static final String ATTRIBUTE_BRIDGE = "Bridge";
    public static final String ATTRIBUTE_SOURCEFILE = "SourceFile";
    public static final String ATTRIBUTE_INNERCLASSES = "InnerClasses";
    public int m_name_index;
    protected long m_attribute_length;

    public String getName(ClassDef cls) {
        return ((CONSTANT_Utf8_info)cls.getConstants().get((int)this.m_name_index)).m_value;
    }

    public abstract long length();

    public abstract void accept(IAttributeVisitor var1, Object var2);

    public abstract String toString();

    public static Attribute_info new_Attribute_info(IConstantCollection constants, UDataInputStream bytes) throws IOException {
        int attribute_name_index = bytes.readU2();
        long attribute_length = bytes.readU4();
        CONSTANT_Utf8_info attribute_name = (CONSTANT_Utf8_info)constants.get(attribute_name_index);
        String name = attribute_name.m_value;
        if (ATTRIBUTE_CODE.equals(name)) {
            return new CodeAttribute_info(constants, attribute_name_index, attribute_length, bytes);
        }
        if (ATTRIBUTE_CONSTANT_VALUE.equals(name)) {
            return new ConstantValueAttribute_info(attribute_name_index, attribute_length, bytes);
        }
        if (ATTRIBUTE_EXCEPTIONS.equals(name)) {
            return new ExceptionsAttribute_info(attribute_name_index, attribute_length, bytes);
        }
        if (ATTRIBUTE_INNERCLASSES.equals(name)) {
            return new InnerClassesAttribute_info(attribute_name_index, attribute_length, bytes);
        }
        if (ATTRIBUTE_SYNTHETIC.equals(name)) {
            return new SyntheticAttribute_info(attribute_name_index, attribute_length);
        }
        if (ATTRIBUTE_BRIDGE.equals(name)) {
            return new BridgeAttribute_info(attribute_name_index, attribute_length);
        }
        if (ATTRIBUTE_LINE_NUMBER_TABLE.equals(name)) {
            return new LineNumberTableAttribute_info(attribute_name_index, attribute_length, bytes);
        }
        if (ATTRIBUTE_SOURCEFILE.equals(name)) {
            return new SourceFileAttribute_info(attribute_name_index, attribute_length, bytes);
        }
        return new GenericAttribute_info(attribute_name_index, attribute_length, bytes);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public void writeInClassFormat(UDataOutputStream out) throws IOException {
        out.writeU2(this.m_name_index);
        out.writeU4(this.length() - 6L);
    }

    protected Attribute_info(int attribute_name_index, long attribute_length) {
        this.m_name_index = attribute_name_index;
        this.m_attribute_length = attribute_length;
    }
}

