/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package junit.framework.test;

import ccl.util.Test;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import junit.framework.TestCase;

/**
 * Tests the redirecting of test code written for the JUnit
 * test framework to the ccl.util.Test class.
 *
 * @version $Id: TestCaseTest.java,v 1.3 2003/05/01 16:45:02 clemens Exp clemens $
 * @author  Chr. Clemens Lee
 */
public class TestCaseTest extends Test 
{
    /**
     * Tests the TestCase.getMethods method.
     */
    public void testGetMethods()
    {
        _enterSubTest( "getMethods" );

        Vector vMethods = TestCase.getMethods( this );
        Assert( vMethods != null );
        Assert( vMethods.size() >= 2 );
        Assert( containsMethod( vMethods, "testGetMethods"     ) );
        Assert( containsMethod( vMethods, "testGetTestMethods" ) );
        Assert( containsMethod( vMethods, "testDummy2"         ) );
        Assert( containsMethod( vMethods, "testDummy3"         ) );

        _exitSubTest();
    }

    /**
     * Tests the TestCase.getTestMethods method.
     */
    public void testGetTestMethods()
    {
        _enterSubTest( "getTestMethods" );

        Vector vMethods = TestCase.getTestMethods( this );
        Assert( vMethods != null );
        Assert( vMethods.size() >= 2
                , "Test methods: " + vMethods);
        Assert( containsMethod( vMethods, "testGetMethods"     )          );
        Assert( containsMethod( vMethods, "testGetTestMethods" )          );
        Assert( containsMethod( vMethods, "_doIt"              ) == false );
        Assert( containsMethod( vMethods, "testDummy1"         ) == false );
        Assert( containsMethod( vMethods, "testDummy2"         ) == false );
        Assert( containsMethod( vMethods, "testDummy3"         ) == false );
        Assert( containsMethod( vMethods, "testInvokeMe"       )          );

        _exitSubTest();
    }

    /**
     * Checks if the test case is able to invoke a test method.
     */
    public void testInvokeTestMethod()
        throws Exception
    {
        _enterSubTest( "invokeTestMethod" );

        // find testInvokeMe method
        Vector vMethods = TestCase.getTestMethods( this );
        Method testInvokeMeMethod = (Method) vMethods.elementAt( indexOfMethod( vMethods, "testInvokeMe" ) );

        hasBeenInvoked = false;
        TestCase.invokeTestMethod( testInvokeMeMethod, this );
        Assert( hasBeenInvoked );

        _exitSubTest();
    }

    /**
     * This is just a dummy method needed for a self test.
     */
    private void testDummy1() {}

    /**
     * This is just a dummy method needed for a self test.
     */
    public int testDummy2()
    {
        return -1;
    }

    /**
     * This is just a dummy method needed for a self test.
     */
    public void testDummy3( int i ) {}

    private boolean hasBeenInvoked = false;

    /**
     * This method does not contain a test but should be invoked by the test case class.
     */
    public void testInvokeMe()
    {
        hasBeenInvoked = true;
    }

    /**
     * Checks if the assert method really counts the test.
     */
    public void testAssert()
    {
        _enterSubTest( "testAssert" );

        TestCase testCase = new AssertTestCase();
        testCase.setVerbose( true );
        testCase.run();
        Assert( testCase.getGlobalTests() == 1 );

        _exitSubTest ();
    }

    /**
     * Default constructor has to be present for ccl test to work.
     */
    public TestCaseTest() 
    {
        super();
    }

    /**
     * Standard constructor has to be present for ccl test to work.
     */
    public TestCaseTest( Test pTest_ ) 
    {
        super( pTest_ );
    }

    /**
     * Work routine that invokes all test methods.
     *
     * @exception   Exception   if anything goes wrong the test fails as well.
     */
    protected void _doIt()
        throws Exception
    {
        testAssert          ();
        testInvokeTestMethod();
        testGetTestMethods  ();
        testGetMethods      ();
    }

    /**
     * Main method if you want to execute just this test class alone.
     */
    public static void main( String[] asArg_ ) 
    {
        Test pTest = (Test)(new TestCaseTest());
        pTest.setVerbose( true );
        pTest.setTiming ( true );
        pTest.run();
        Test.printResult( pTest );

        System.exit( 0 );
    }

    /**
     * Returns the index of a method with a given name.
     */
    static public int indexOfMethod( Vector vMethods, String sMethodName )
    {
        boolean methodFound = false;
        Enumeration eMethods = vMethods.elements();
        int index = 0;
        while( eMethods.hasMoreElements() )
        {
            Method nextMethod = (Method) eMethods.nextElement();
            String sMethods = nextMethod.getName();
            if ( sMethods.equals( sMethodName ) )
            {
                return index;
            }
            index++;
        }

        return -1;
    }

    /**
     * Checks if a vector of method objects contains a method with a certain name.
     */
    static public boolean containsMethod( Vector vMethods, String sMethodName )
    {
        return indexOfMethod( vMethods, sMethodName ) != -1;
    }
}
