/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.util.test;

import ccl.util.Test;

/**
 * Tests the ccl.util.Test class which is the center of
 * the testing API.
 *
 * @version $Id: TestTest.java,v 1.2 2003/05/01 16:44:54 clemens Exp clemens $
 * @author  Chr. Clemens Lee (clemens@kclee.com)
 */
public class TestTest extends Test 
{
    /**
     * Checks that a test name is the name of the test class without the trailing "Test"
     * part (so the test name is the leading part of the test class name).
     *
     * @throws   Exception   any exception gets forwarded so it can be counted as a bug.
     */
    public void testGetTestName()
        throws Exception
    {
        /* _enterSubTest( "getTestName" ); */

        Assert( Test.getTestName( "TestTest" ).equals( "Test" )
                , "TestTest test name: '" + Test.getTestName( "TestTest" ) + "'" );
        Assert( Test.getTestName( "TestDummy" ).equals( "Dummy" ) );

        Test dummyTest = new UtilTest();
        Assert( Test.getTestName( dummyTest   ).equals( "Util" ) );
        dummyTest = new TestTest();
        Assert( Test.getTestName( dummyTest   ).equals( "Test" ) );
        Object dummyObject = new TestDummy();
        Assert( Test.getTestName( dummyObject ).equals( "Dummy" ) );

        /* _exitSubTest (); */
    }

    /**
     * Default constructor needed by Test API.
     */
    public TestTest() 
    {
        super();
    }


    /**
     * Standard constructor needed by Test API.
     */
    public TestTest( Test pTest_ ) 
    {
        super( pTest_ );
    }


    /**
     * Main method to invoke all test methods.
     *
     * @exception   Exception   if anything goes wrong the test fails as well.
     */
    protected void _doIt()
        throws Exception
    {
        testGetTestName();

        /*
        // bug when whole test succeeds while sub test still fails
        Test pTest = (Test) (new FailingTest());
        pTest.setVerbose( true );
        pTest.run();
        pTest.printResult( pTest );
        // */
    }

    /**
     * Comment to fool checkstyle.
     */
    public static class FailingTest extends Test 
    {
        public FailingTest() 
        {
            super();
        }

        public FailingTest( Test pTest_ ) 
        {
            super( pTest_ );
        }

        protected void _doIt()
            throws Exception
        {
            _enterSubTest( "level 1" );
            {
                bugIf( false );
                
                _enterSubTest( "level 2" );
                {
                    bugIf( false );
                    
                    _enterSubTest( "level 3" );
                    {
                        bugIf( true );
                    }
                    _exitSubTest();

                    bugIf( false );
                }
                _exitSubTest();

                bugIf( false );
            }
            _exitSubTest();

            Test pTest = new SuccessfullTest();
            pTest.run();
            setTests( pTest );
        }
    }

    /**
     * Comment to fool checkstyle.
     */
    public static class SuccessfullTest extends Test 
    {
        public SuccessfullTest() 
        {
            super();
        }

        public SuccessfullTest( Test pTest_ ) 
        {
            super( pTest_ );
        }

        protected void _doIt()
            throws Exception
        {
            _enterSubTest( "level 1" );
            {
                bugIf( false );
                
                _enterSubTest( "level 2" );
                {
                    bugIf( false );
                    
                    _enterSubTest( "level 3" );
                    {
                        bugIf( false );
                    }
                    _exitSubTest();

                    bugIf( false );
                }
                _exitSubTest();

                bugIf( false );
            }
            _exitSubTest();
        }
    }

    /**
     * Use this main class if you want to run the self test of this class alone,
     * otherwise use ccl.Main -check.
     */
    public static void main( String[] asArg_ ) {
        Test pTest = (Test)(new TestTest());
        pTest.setVerbose( true );
        pTest.setTiming ( true );
        pTest.run();
        pTest.printResult();

        System.exit( 0 );
    }
}
